<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Http\Controllers\BackupController;

class BackupClean extends Command
{
    protected $signature = 'backup:clean';
    protected $description = 'Clean old backups based on retention days';

    public function handle()
    {
        $this->info('Cleaning old backups...');

        try {
            // Get retention days from settings
            $retentionDays = \App\Models\Setting::get('backup_retention_days', env('BACKUP_RETENTION_DAYS', 14));
            $deletedCount = BackupController::cleanOldBackups($retentionDays);
            $this->info("Cleaned {$deletedCount} old backup(s).");
            return 0;
        } catch (\Exception $e) {
            $this->error('Cleanup failed: ' . $e->getMessage());
            return 1;
        }
    }
}
