<?php

namespace App\Console\Commands;

use App\Services\LicenseDatabaseService;
use Illuminate\Console\Command;

class BackupLicenseDatabase extends Command
{
    protected $signature = 'license:backup {--path= : مسار النسخة الاحتياطية}';

    protected $description = 'إنشاء نسخة احتياطية من قاعدة بيانات التراخيص';

    public function handle()
    {
        $licenseDb = app(LicenseDatabaseService::class);
        
        $backupPath = $this->option('path');
        
        $this->info('إنشاء نسخة احتياطية...');
        
        $success = $licenseDb->backup($backupPath);
        
        if ($success) {
            $finalPath = $backupPath ?: storage_path('app/backups/licenses_' . date('Y-m-d_His') . '.db');
            $this->info("✅ تم إنشاء النسخة الاحتياطية بنجاح!");
            $this->info("الموقع: {$finalPath}");
        } else {
            $this->error('❌ فشل إنشاء النسخة الاحتياطية');
            return 1;
        }
        
        return 0;
    }
}






