<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Http\Controllers\BackupController;

class BackupRun extends Command
{
    protected $signature = 'backup:run';
    protected $description = 'Create a database backup';

    public function handle()
    {
        $this->info('Creating database backup...');

        try {
            BackupController::createBackup();
            $this->info('Backup created successfully!');
            return 0;
        } catch (\Exception $e) {
            $this->error('Backup failed: ' . $e->getMessage());
            return 1;
        }
    }
}
