<?php

namespace App\Console\Commands;

use App\Services\LicenseDatabaseService;
use Illuminate\Console\Command;
use Carbon\Carbon;

class ListLicenses extends Command
{
    protected $signature = 'license:list';

    protected $description = 'عرض قائمة جميع التراخيص';

    public function handle()
    {
        $licenseDb = app(LicenseDatabaseService::class);
        $licenses = $licenseDb->all();

        if (empty($licenses)) {
            $this->info('لا توجد تراخيص في قاعدة البيانات.');
            return 0;
        }

        $data = array_map(function ($license) {
            return [
                'ID' => $license['id'] ?? 'N/A',
                'License Key' => substr($license['license_key'], 0, 12) . '****',
                'Serial Number' => $license['serial_number'],
                'العميل' => $license['customer_name'] ?? 'غير محدد',
                'Email' => $license['email'] ?? 'غير محدد',
                'الحالة' => $this->getStatusLabel($license['status'] ?? 'pending'),
                'الجهاز' => $license['machine_name'] ?? 'غير مفعّل',
                'Machine ID' => isset($license['machine_id']) && $license['machine_id'] ? substr($license['machine_id'], 0, 8) . '****' : 'غير محفوظ',
                'تاريخ التفعيل' => isset($license['activated_at']) ? Carbon::parse($license['activated_at'])->format('Y-m-d') : 'غير مفعّل',
                'تاريخ الانتهاء' => isset($license['expires_at']) ? Carbon::parse($license['expires_at'])->format('Y-m-d') : 'دائم',
            ];
        }, $licenses);

        $this->table(
            ['ID', 'License Key', 'Serial Number', 'العميل', 'Email', 'الحالة', 'الجهاز', 'Machine ID', 'تاريخ التفعيل', 'تاريخ الانتهاء'],
            $data
        );

        return 0;
    }

    protected function getStatusLabel($status): string
    {
        $labels = [
            'pending' => '⏳ في الانتظار',
            'active' => '✅ مفعّل',
            'expired' => '❌ منتهي',
            'suspended' => '🚫 معلّق',
        ];

        return $labels[$status] ?? $status;
    }
}

