<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Services\TrialService;
use App\Services\LicenseService;
use Carbon\Carbon;

class TestTrial extends Command
{
    protected $signature = 'trial:test';
    protected $description = 'اختبار نظام الفترة التجريبية';

    public function handle(TrialService $trialService, LicenseService $licenseService)
    {
        $this->info('=== اختبار نظام الفترة التجريبية ===');
        $this->newLine();
        
        // معلومات الفترة
        $startDate = $trialService->getStartDate();
        $endDate = $trialService->getEndDate();
        $isExpired = $trialService->isExpired();
        $daysRemaining = $trialService->getDaysRemaining();
        $hasLicense = $licenseService->verifyLocal();
        
        $this->info("تاريخ البداية: {$startDate->format('Y-m-d')}");
        $this->info("تاريخ الانتهاء: {$endDate->format('Y-m-d')}");
        $this->info("التاريخ الحالي: " . Carbon::now()->format('Y-m-d'));
        $this->newLine();
        
        $this->info("الأيام المتبقية: {$daysRemaining}");
        $this->info("منتهية: " . ($isExpired ? 'نعم ✅' : 'لا ❌'));
        $this->info("يوجد ترخيص: " . ($hasLicense ? 'نعم ✅' : 'لا ❌'));
        $this->newLine();
        
        if ($isExpired && !$hasLicense) {
            $this->warn("⚠️  يجب منع الوصول - الفترة منتهية وليس هناك ترخيص");
            $this->info("المتوقع: توجيه إلى /trial/expired");
        } else {
            $this->info("✅ النظام يعمل بشكل طبيعي");
        }
        
        return 0;
    }
}
