<?php

namespace App\Console\Commands;

use App\Services\LicenseDatabaseService;
use App\Services\MachineIdService;
use Illuminate\Console\Command;

class TransferLicense extends Command
{
    protected $signature = 'license:transfer 
                            {license_key : License Key}
                            {--force : Force transfer even if already activated}';

    protected $description = 'نقل ترخيص من جهاز لآخر (للمطور فقط)';

    public function handle()
    {
        $licenseKey = strtoupper($this->argument('license_key'));
        $force = $this->option('force');

        $licenseDb = app(LicenseDatabaseService::class);
        $license = $licenseDb->find($licenseKey);

        if (!$license) {
            $this->error("الترخيص غير موجود: {$licenseKey}");
            return 1;
        }

        $this->info("الترخيص: " . substr($license['license_key'], 0, 12) . '****');
        $this->info("Serial Number: {$license['serial_number']}");
        $this->info("الحالة الحالية: {$license['status']}");
        
        if (isset($license['machine_id']) && $license['machine_id']) {
            $this->warn("الترخيص مفعّل حالياً على جهاز: {$license['machine_name']} (" . substr($license['machine_id'], 0, 8) . "****)");
        }

        if (!$force && isset($license['machine_id']) && $license['machine_id']) {
            if (!$this->confirm('هل تريد نقل الترخيص من الجهاز الحالي؟', false)) {
                $this->info('تم الإلغاء');
                return 0;
            }
        }

        $machineIdService = app(MachineIdService::class);
        $newMachineId = $machineIdService->getMachineId();
        $newMachineName = $machineIdService->getMachineName();

        $licenseDb->update($licenseKey, [
            'machine_id' => $newMachineId,
            'machine_name' => $newMachineName,
            'ip_address' => request()->ip() ?? '127.0.0.1',
        ]);

        $this->info("✅ تم نقل الترخيص بنجاح!");
        $this->info("الجهاز الجديد: {$newMachineName}");
        $this->info("Machine ID: {$newMachineId}");

        return 0;
    }
}

