<?php

namespace App\Console;

use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Foundation\Console\Kernel as ConsoleKernel;

class Kernel extends ConsoleKernel
{
    protected $commands = [
        //
    ];

    protected function schedule(Schedule $schedule): void
    {
        // $schedule->command('inspire')->hourly();
        
        // Automatic backup scheduling (configurable)
        $autoBackupEnabled = \App\Models\Setting::get('auto_backup_enabled', '0') === '1';
        $autoBackupFrequency = \App\Models\Setting::get('auto_backup_frequency', 'daily');
        $autoBackupTime = \App\Models\Setting::get('auto_backup_time', '02:00');
        
        if ($autoBackupEnabled) {
            if ($autoBackupFrequency === 'daily') {
                $schedule->command('backup:run')->dailyAt($autoBackupTime);
            } elseif ($autoBackupFrequency === 'weekly') {
                $schedule->command('backup:run')->weeklyOn(1, $autoBackupTime); // Monday
            }
        }
        
        // Clean old backups daily at 02:30 AM
        $schedule->command('backup:clean')->dailyAt('02:30');
        
        // Send invoice reminders daily at 09:00 AM
        $schedule->command('invoices:send-reminders')->dailyAt('09:00');
        
        // Check stock alerts every hour
        $schedule->command('stock:check-alerts')->hourly();
        
        // Generate purchase orders daily at 10:00 AM (if alerts exist)
        $schedule->command('stock:generate-purchase-orders')->dailyAt('10:00');
        
        // Schedule monthly stock takes on the 1st of each month at 08:00 AM
        $schedule->command('stock:schedule-takes --type=full')->monthlyOn(1, '08:00');
        
        // Clean old activity logs daily at 03:00 AM
        $schedule->command('activity-logs:clean')->dailyAt('03:00');
    }

    protected function commands(): void
    {
        $this->load(__DIR__.'/Commands');

        require base_path('routes/console.php');
    }
}

