<?php

namespace App\Exports;

use App\Models\Invoice;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class InvoicesExport implements FromCollection, WithHeadings, WithMapping, ShouldAutoSize
{
    protected $invoices;

    public function __construct($invoices = null)
    {
        $this->invoices = $invoices ?? Invoice::with(['customer', 'user'])->get();
    }

    public function collection()
    {
        return $this->invoices;
    }

    public function headings(): array
    {
        return [
            'Invoice Number',
            'Date',
            'Customer',
            'Customer Name',
            'Status',
            'Subtotal',
            'Tax',
            'Discount',
            'Total',
            'Paid Amount',
            'Due Amount',
            'Notes',
            'Created By',
        ];
    }

    public function map($invoice): array
    {
        return [
            $invoice->invoice_number,
            $invoice->created_at->format('Y-m-d H:i'),
            $invoice->customer?->name ?? '',
            $invoice->customer_name,
            $invoice->status,
            $invoice->subtotal,
            $invoice->tax,
            $invoice->discount,
            $invoice->total,
            $invoice->paid_amount,
            $invoice->due_amount,
            $invoice->notes ?? '',
            $invoice->user->name ?? '',
        ];
    }
}

