<?php

namespace App\Exports;

use App\Models\Invoice;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithMapping;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;

class SalesReportExport implements FromCollection, WithHeadings, WithMapping, ShouldAutoSize
{
    protected $invoices;

    public function __construct($invoices)
    {
        $this->invoices = $invoices;
    }

    public function collection()
    {
        return $this->invoices;
    }

    public function headings(): array
    {
        return [
            'Invoice Number',
            'Date',
            'Customer',
            'Status',
            'Subtotal',
            'Tax',
            'Discount',
            'Total',
            'Paid',
            'Due',
            'Profit',
        ];
    }

    public function map($invoice): array
    {
        // Calculate profit for each invoice
        $profit = $invoice->items->sum(function ($item) {
            $revenue = $item->total;
            $cost = $item->quantity * ($item->product->purchase_price ?? 0);
            return $revenue - $cost;
        });
        
        return [
            $invoice->invoice_number,
            $invoice->created_at->format('Y-m-d H:i'),
            $invoice->customer?->name ?? $invoice->customer_name,
            $invoice->status,
            $invoice->subtotal,
            $invoice->tax,
            $invoice->discount,
            $invoice->total,
            $invoice->paid_amount,
            $invoice->due_amount,
            $profit,
        ];
    }
}

