<?php

if (!function_exists('storage_url')) {
    /**
     * Get the URL for a storage file
     * Works without symlink by using a route
     * 
     * @param string $path
     * @return string
     */
    function storage_url($path)
    {
        if (empty($path)) {
            return '';
        }
        
        // Remove 'storage/' prefix if exists (use str_replace instead of ltrim to avoid removing individual characters)
        if (strpos($path, 'storage/') === 0) {
            $path = substr($path, 8); // Remove 'storage/' (8 characters)
        }
        $path = ltrim($path, '/');
        
        // Use route if symlink doesn't work, otherwise use asset
        if (env('USE_STORAGE_ROUTE', true)) {
            // Encode each segment separately to preserve slashes
            $segments = explode('/', $path);
            $encodedSegments = array_map('rawurlencode', $segments);
            $encodedPath = implode('/', $encodedSegments);
            return url('storage/' . $encodedPath);
        }
        
        return asset('storage/' . $path);
    }
}

