<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Auth;

class LanguageController extends Controller
{
    public function switch(Request $request, $locale)
    {
        if (in_array($locale, ['en', 'ar', 'fr'])) {
            Session::put('locale', $locale);
            Session::save();
            App::setLocale($locale);
            
            // حفظ اللغة في قاعدة البيانات إذا كان المستخدم مسجل الدخول
            if (Auth::check()) {
                Auth::user()->update(['locale' => $locale]);
            }
        }
        
        return redirect()->back();
    }
}

