<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

class UserGuideController extends Controller
{
    public function index(Request $request)
    {
        $faqs = $this->getFAQs();
        $categories = $this->getCategories();
        
        $search = $request->get('search', '');
        $category = $request->get('category', '');
        
        // Filter FAQs based on search and category
        $filteredFaqs = $faqs;
        
        if ($category) {
            $filteredFaqs = array_filter($filteredFaqs, function($faq) use ($category) {
                return $faq['category'] === $category;
            });
        }
        
        if ($search) {
            $searchLower = mb_strtolower($search);
            $filteredFaqs = array_filter($filteredFaqs, function($faq) use ($searchLower) {
                $question = mb_strtolower($faq['question']);
                $answer = mb_strtolower($faq['answer']);
                return strpos($question, $searchLower) !== false || strpos($answer, $searchLower) !== false;
            });
        }
        
        return view('user-guide.index', [
            'faqs' => $filteredFaqs,
            'categories' => $categories,
            'search' => $search,
            'selectedCategory' => $category,
        ]);
    }

    private function getCategories()
    {
        return [
            'getting-started' => trans('messages.getting_started'),
            'products' => trans('messages.products'),
            'categories' => trans('messages.categories'),
            'invoices' => trans('messages.invoices'),
            'customers' => trans('messages.customers'),
            'suppliers' => trans('messages.suppliers'),
            'purchase-invoices' => trans('messages.purchase_invoices'),
            'pos' => trans('messages.pos'),
            'reports' => trans('messages.reports'),
            'treasury' => trans('messages.treasury'),
            'accounting' => trans('messages.accounting'),
            'cheques' => trans('messages.cheques'),
            'promissory-notes' => trans('messages.promissory_notes'),
            'exports' => trans('messages.exports'),
            'printing' => trans('messages.printing'),
            'filtering' => trans('messages.filtering'),
            'settings' => trans('messages.settings'),
            'system-management' => trans('messages.system_management'),
        ];
    }

    private function getFAQs()
    {
        return [
            // ============================================
            // GETTING STARTED
            // ============================================
            [
                'id' => 1,
                'category' => 'getting-started',
                'question' => trans('messages.faq_how_to_login'),
                'answer' => trans('messages.faq_how_to_login_answer'),
            ],
            [
                'id' => 2,
                'category' => 'getting-started',
                'question' => trans('messages.faq_how_to_change_language'),
                'answer' => trans('messages.faq_how_to_change_language_answer'),
            ],
            [
                'id' => 3,
                'category' => 'getting-started',
                'question' => trans('messages.faq_what_are_user_roles'),
                'answer' => trans('messages.faq_what_are_user_roles_answer'),
            ],
            [
                'id' => 47,
                'category' => 'getting-started',
                'question' => trans('messages.faq_how_to_logout'),
                'answer' => trans('messages.faq_how_to_logout_answer'),
            ],
            [
                'id' => 48,
                'category' => 'getting-started',
                'question' => trans('messages.faq_how_to_change_password'),
                'answer' => trans('messages.faq_how_to_change_password_answer'),
            ],
            
            // ============================================
            // PRODUCTS
            // ============================================
            [
                'id' => 4,
                'category' => 'products',
                'question' => trans('messages.faq_how_to_add_product'),
                'answer' => trans('messages.faq_how_to_add_product_answer'),
            ],
            [
                'id' => 5,
                'category' => 'products',
                'question' => trans('messages.faq_how_to_import_products'),
                'answer' => trans('messages.faq_how_to_import_products_answer'),
            ],
            [
                'id' => 6,
                'category' => 'products',
                'question' => trans('messages.faq_how_to_generate_sku'),
                'answer' => trans('messages.faq_how_to_generate_sku_answer'),
            ],
            [
                'id' => 7,
                'category' => 'products',
                'question' => trans('messages.faq_how_to_print_barcode'),
                'answer' => trans('messages.faq_how_to_print_barcode_answer'),
            ],
            [
                'id' => 28,
                'category' => 'products',
                'question' => trans('messages.faq_how_to_edit_product'),
                'answer' => trans('messages.faq_how_to_edit_product_answer'),
            ],
            [
                'id' => 29,
                'category' => 'products',
                'question' => trans('messages.faq_how_to_delete_product'),
                'answer' => trans('messages.faq_how_to_delete_product_answer'),
            ],
            [
                'id' => 30,
                'category' => 'products',
                'question' => trans('messages.faq_how_to_export_products'),
                'answer' => trans('messages.faq_how_to_export_products_answer'),
            ],
            [
                'id' => 31,
                'category' => 'products',
                'question' => trans('messages.faq_what_is_low_stock'),
                'answer' => trans('messages.faq_what_is_low_stock_answer'),
            ],
            
            // ============================================
            // CATEGORIES
            // ============================================
            [
                'id' => 8,
                'category' => 'categories',
                'question' => trans('messages.faq_how_to_add_category'),
                'answer' => trans('messages.faq_how_to_add_category_answer'),
            ],
            [
                'id' => 9,
                'category' => 'categories',
                'question' => trans('messages.faq_how_to_import_categories'),
                'answer' => trans('messages.faq_how_to_import_categories_answer'),
            ],
            [
                'id' => 49,
                'category' => 'categories',
                'question' => trans('messages.faq_how_to_edit_category'),
                'answer' => trans('messages.faq_how_to_edit_category_answer'),
            ],
            [
                'id' => 50,
                'category' => 'categories',
                'question' => trans('messages.faq_how_to_delete_category'),
                'answer' => trans('messages.faq_how_to_delete_category_answer'),
            ],
            
            // ============================================
            // INVOICES
            // ============================================
            [
                'id' => 10,
                'category' => 'invoices',
                'question' => trans('messages.faq_how_to_create_invoice'),
                'answer' => trans('messages.faq_how_to_create_invoice_answer'),
            ],
            [
                'id' => 11,
                'category' => 'invoices',
                'question' => trans('messages.faq_how_to_record_payment'),
                'answer' => trans('messages.faq_how_to_record_payment_answer'),
            ],
            [
                'id' => 12,
                'category' => 'invoices',
                'question' => trans('messages.faq_how_to_return_invoice'),
                'answer' => trans('messages.faq_how_to_return_invoice_answer'),
            ],
            [
                'id' => 13,
                'category' => 'invoices',
                'question' => trans('messages.faq_how_to_export_invoices'),
                'answer' => trans('messages.faq_how_to_export_invoices_answer'),
            ],
            [
                'id' => 32,
                'category' => 'invoices',
                'question' => trans('messages.faq_how_to_edit_invoice'),
                'answer' => trans('messages.faq_how_to_edit_invoice_answer'),
            ],
            [
                'id' => 33,
                'category' => 'invoices',
                'question' => trans('messages.faq_how_to_delete_payment'),
                'answer' => trans('messages.faq_how_to_delete_payment_answer'),
            ],
            [
                'id' => 34,
                'category' => 'invoices',
                'question' => trans('messages.faq_what_are_invoice_statuses'),
                'answer' => trans('messages.faq_what_are_invoice_statuses_answer'),
            ],
            [
                'id' => 35,
                'category' => 'invoices',
                'question' => trans('messages.faq_how_to_apply_discount'),
                'answer' => trans('messages.faq_how_to_apply_discount_answer'),
            ],
            
            // ============================================
            // CUSTOMERS
            // ============================================
            [
                'id' => 14,
                'category' => 'customers',
                'question' => trans('messages.faq_how_to_add_customer'),
                'answer' => trans('messages.faq_how_to_add_customer_answer'),
            ],
            [
                'id' => 15,
                'category' => 'customers',
                'question' => trans('messages.faq_how_to_import_customers'),
                'answer' => trans('messages.faq_how_to_import_customers_answer'),
            ],
            [
                'id' => 36,
                'category' => 'customers',
                'question' => trans('messages.faq_how_to_view_customer_balance'),
                'answer' => trans('messages.faq_how_to_view_customer_balance_answer'),
            ],
            [
                'id' => 37,
                'category' => 'customers',
                'question' => trans('messages.faq_how_to_record_customer_payment'),
                'answer' => trans('messages.faq_how_to_record_customer_payment_answer'),
            ],
            
            // ============================================
            // SUPPLIERS
            // ============================================
            [
                'id' => 16,
                'category' => 'suppliers',
                'question' => trans('messages.faq_how_to_add_supplier'),
                'answer' => trans('messages.faq_how_to_add_supplier_answer'),
            ],
            [
                'id' => 17,
                'category' => 'suppliers',
                'question' => trans('messages.faq_how_to_import_suppliers'),
                'answer' => trans('messages.faq_how_to_import_suppliers_answer'),
            ],
            [
                'id' => 38,
                'category' => 'suppliers',
                'question' => trans('messages.faq_how_to_view_supplier_balance'),
                'answer' => trans('messages.faq_how_to_view_supplier_balance_answer'),
            ],
            [
                'id' => 39,
                'category' => 'suppliers',
                'question' => trans('messages.faq_how_to_record_supplier_balance_payment'),
                'answer' => trans('messages.faq_how_to_record_supplier_balance_payment_answer'),
            ],
            
            // ============================================
            // PURCHASE INVOICES
            // ============================================
            [
                'id' => 18,
                'category' => 'purchase-invoices',
                'question' => trans('messages.faq_how_to_create_purchase_invoice'),
                'answer' => trans('messages.faq_how_to_create_purchase_invoice_answer'),
            ],
            [
                'id' => 19,
                'category' => 'purchase-invoices',
                'question' => trans('messages.faq_how_to_record_supplier_payment'),
                'answer' => trans('messages.faq_how_to_record_supplier_payment_answer'),
            ],
            [
                'id' => 51,
                'category' => 'purchase-invoices',
                'question' => trans('messages.faq_how_to_edit_purchase_invoice'),
                'answer' => trans('messages.faq_how_to_edit_purchase_invoice_answer'),
            ],
            [
                'id' => 52,
                'category' => 'purchase-invoices',
                'question' => trans('messages.faq_how_to_return_purchase_invoice'),
                'answer' => trans('messages.faq_how_to_return_purchase_invoice_answer'),
            ],
            
            // ============================================
            // POS
            // ============================================
            [
                'id' => 20,
                'category' => 'pos',
                'question' => trans('messages.faq_how_to_use_pos'),
                'answer' => trans('messages.faq_how_to_use_pos_answer'),
            ],
            [
                'id' => 200,
                'category' => 'pos',
                'question' => trans('messages.faq_how_to_apply_discount_in_pos'),
                'answer' => trans('messages.faq_how_to_apply_discount_in_pos_answer'),
            ],
            [
                'id' => 201,
                'category' => 'pos',
                'question' => trans('messages.faq_how_to_save_draft_in_pos'),
                'answer' => trans('messages.faq_how_to_save_draft_in_pos_answer'),
            ],
            [
                'id' => 202,
                'category' => 'pos',
                'question' => trans('messages.faq_how_to_use_fullscreen_in_pos'),
                'answer' => trans('messages.faq_how_to_use_fullscreen_in_pos_answer'),
            ],
            [
                'id' => 203,
                'category' => 'pos',
                'question' => trans('messages.faq_how_to_use_barcode_scanner_in_pos'),
                'answer' => trans('messages.faq_how_to_use_barcode_scanner_in_pos_answer'),
            ],
            [
                'id' => 204,
                'category' => 'pos',
                'question' => trans('messages.faq_how_to_quick_add_customer_in_pos'),
                'answer' => trans('messages.faq_how_to_quick_add_customer_in_pos_answer'),
            ],
            [
                'id' => 205,
                'category' => 'pos',
                'question' => trans('messages.faq_how_to_use_favorites_in_pos'),
                'answer' => trans('messages.faq_how_to_use_favorites_in_pos_answer'),
            ],
            
            // ============================================
            // REPORTS
            // ============================================
            [
                'id' => 21,
                'category' => 'reports',
                'question' => trans('messages.faq_how_to_view_sales_report'),
                'answer' => trans('messages.faq_how_to_view_sales_report_answer'),
            ],
            [
                'id' => 22,
                'category' => 'reports',
                'question' => trans('messages.faq_how_to_export_report'),
                'answer' => trans('messages.faq_how_to_export_report_answer'),
            ],
            [
                'id' => 40,
                'category' => 'reports',
                'question' => trans('messages.faq_how_to_view_products_report'),
                'answer' => trans('messages.faq_how_to_view_products_report_answer'),
            ],
            [
                'id' => 41,
                'category' => 'reports',
                'question' => trans('messages.faq_how_to_view_profit_report'),
                'answer' => trans('messages.faq_how_to_view_profit_report_answer'),
            ],
            [
                'id' => 42,
                'category' => 'reports',
                'question' => trans('messages.faq_how_to_view_stock_report'),
                'answer' => trans('messages.faq_how_to_view_stock_report_answer'),
            ],
            [
                'id' => 43,
                'category' => 'reports',
                'question' => trans('messages.faq_how_to_filter_reports'),
                'answer' => trans('messages.faq_how_to_filter_reports_answer'),
            ],
            [
                'id' => 160,
                'category' => 'accounting',
                'question' => trans('messages.faq_how_to_view_cash_flow_report'),
                'answer' => trans('messages.faq_how_to_view_cash_flow_report_answer'),
            ],
            [
                'id' => 161,
                'category' => 'accounting',
                'question' => trans('messages.faq_how_to_view_profit_loss_report'),
                'answer' => trans('messages.faq_how_to_view_profit_loss_report_answer'),
            ],
            [
                'id' => 162,
                'category' => 'accounting',
                'question' => trans('messages.faq_how_to_view_balance_sheet'),
                'answer' => trans('messages.faq_how_to_view_balance_sheet_answer'),
            ],
            [
                'id' => 163,
                'category' => 'accounting',
                'question' => trans('messages.faq_how_to_view_cost_analysis'),
                'answer' => trans('messages.faq_how_to_view_cost_analysis_answer'),
            ],
            [
                'id' => 164,
                'category' => 'accounting',
                'question' => trans('messages.faq_how_to_print_accounting_reports'),
                'answer' => trans('messages.faq_how_to_print_accounting_reports_answer'),
            ],
            
            // ============================================
            // TREASURY
            // ============================================
            [
                'id' => 23,
                'category' => 'treasury',
                'question' => trans('messages.faq_what_is_treasury'),
                'answer' => trans('messages.faq_what_is_treasury_answer'),
            ],
            [
                'id' => 24,
                'category' => 'treasury',
                'question' => trans('messages.faq_how_to_add_manual_transaction'),
                'answer' => trans('messages.faq_how_to_add_manual_transaction_answer'),
            ],
            [
                'id' => 44,
                'category' => 'treasury',
                'question' => trans('messages.faq_how_to_view_treasury_dashboard'),
                'answer' => trans('messages.faq_how_to_view_treasury_dashboard_answer'),
            ],
            [
                'id' => 45,
                'category' => 'treasury',
                'question' => trans('messages.faq_how_to_edit_treasury_transaction'),
                'answer' => trans('messages.faq_how_to_edit_treasury_transaction_answer'),
            ],
            [
                'id' => 46,
                'category' => 'treasury',
                'question' => trans('messages.faq_how_to_export_treasury'),
                'answer' => trans('messages.faq_how_to_export_treasury_answer'),
            ],
            
            // ============================================
            // ACCOUNTING - CHEQUES
            // ============================================
            [
                'id' => 100,
                'category' => 'cheques',
                'question' => trans('messages.faq_what_are_cheques'),
                'answer' => trans('messages.faq_what_are_cheques_answer'),
            ],
            [
                'id' => 101,
                'category' => 'cheques',
                'question' => trans('messages.faq_how_to_add_cheque'),
                'answer' => trans('messages.faq_how_to_add_cheque_answer'),
            ],
            [
                'id' => 102,
                'category' => 'cheques',
                'question' => trans('messages.faq_how_to_link_cheque_to_invoice'),
                'answer' => trans('messages.faq_how_to_link_cheque_to_invoice_answer'),
            ],
            [
                'id' => 103,
                'category' => 'cheques',
                'question' => trans('messages.faq_how_to_mark_cheque_as_paid'),
                'answer' => trans('messages.faq_how_to_mark_cheque_as_paid_answer'),
            ],
            [
                'id' => 104,
                'category' => 'cheques',
                'question' => trans('messages.faq_how_to_mark_cheque_as_returned'),
                'answer' => trans('messages.faq_how_to_mark_cheque_as_returned_answer'),
            ],
            [
                'id' => 105,
                'category' => 'cheques',
                'question' => trans('messages.faq_what_are_cheque_statuses'),
                'answer' => trans('messages.faq_what_are_cheque_statuses_answer'),
            ],
            [
                'id' => 106,
                'category' => 'cheques',
                'question' => trans('messages.faq_how_to_create_cheque_from_payment'),
                'answer' => trans('messages.faq_how_to_create_cheque_from_payment_answer'),
            ],
            
            // ============================================
            // ACCOUNTING - PROMISSORY NOTES
            // ============================================
            [
                'id' => 110,
                'category' => 'promissory-notes',
                'question' => trans('messages.faq_what_are_promissory_notes'),
                'answer' => trans('messages.faq_what_are_promissory_notes_answer'),
            ],
            [
                'id' => 111,
                'category' => 'promissory-notes',
                'question' => trans('messages.faq_how_to_add_promissory_note'),
                'answer' => trans('messages.faq_how_to_add_promissory_note_answer'),
            ],
            [
                'id' => 112,
                'category' => 'promissory-notes',
                'question' => trans('messages.faq_how_to_link_promissory_note_to_invoice'),
                'answer' => trans('messages.faq_how_to_link_promissory_note_to_invoice_answer'),
            ],
            [
                'id' => 113,
                'category' => 'promissory-notes',
                'question' => trans('messages.faq_how_to_mark_promissory_note_as_paid'),
                'answer' => trans('messages.faq_how_to_mark_promissory_note_as_paid_answer'),
            ],
            [
                'id' => 114,
                'category' => 'promissory-notes',
                'question' => trans('messages.faq_what_are_promissory_note_statuses'),
                'answer' => trans('messages.faq_what_are_promissory_note_statuses_answer'),
            ],
            [
                'id' => 115,
                'category' => 'promissory-notes',
                'question' => trans('messages.faq_how_to_create_promissory_note_from_payment'),
                'answer' => trans('messages.faq_how_to_create_promissory_note_from_payment_answer'),
            ],
            
            // ============================================
            // EXPORTS
            // ============================================
            [
                'id' => 120,
                'category' => 'exports',
                'question' => trans('messages.faq_how_to_export_quotation'),
                'answer' => trans('messages.faq_how_to_export_quotation_answer'),
            ],
            [
                'id' => 121,
                'category' => 'exports',
                'question' => trans('messages.faq_how_to_export_delivery_note'),
                'answer' => trans('messages.faq_how_to_export_delivery_note_answer'),
            ],
            [
                'id' => 122,
                'category' => 'exports',
                'question' => trans('messages.faq_how_to_export_purchase_order'),
                'answer' => trans('messages.faq_how_to_export_purchase_order_answer'),
            ],
            [
                'id' => 123,
                'category' => 'exports',
                'question' => trans('messages.faq_what_are_export_notifications'),
                'answer' => trans('messages.faq_what_are_export_notifications_answer'),
            ],
            
            // ============================================
            // PRINTING
            // ============================================
            [
                'id' => 130,
                'category' => 'printing',
                'question' => trans('messages.faq_how_to_print_invoice'),
                'answer' => trans('messages.faq_how_to_print_invoice_answer'),
            ],
            [
                'id' => 131,
                'category' => 'printing',
                'question' => trans('messages.faq_how_to_print_purchase_invoice'),
                'answer' => trans('messages.faq_how_to_print_purchase_invoice_answer'),
            ],
            [
                'id' => 132,
                'category' => 'printing',
                'question' => trans('messages.faq_what_fonts_are_used'),
                'answer' => trans('messages.faq_what_fonts_are_used_answer'),
            ],
            [
                'id' => 133,
                'category' => 'printing',
                'question' => trans('messages.faq_how_to_close_print_page'),
                'answer' => trans('messages.faq_how_to_close_print_page_answer'),
            ],
            
            // ============================================
            // FILTERING
            // ============================================
            [
                'id' => 140,
                'category' => 'filtering',
                'question' => trans('messages.faq_how_to_filter_customers_with_debts'),
                'answer' => trans('messages.faq_how_to_filter_customers_with_debts_answer'),
            ],
            [
                'id' => 141,
                'category' => 'filtering',
                'question' => trans('messages.faq_how_to_filter_suppliers_with_debts'),
                'answer' => trans('messages.faq_how_to_filter_suppliers_with_debts_answer'),
            ],
            [
                'id' => 142,
                'category' => 'filtering',
                'question' => trans('messages.faq_how_to_print_debtors_list'),
                'answer' => trans('messages.faq_how_to_print_debtors_list_answer'),
            ],
            
            // ============================================
            // SETTINGS
            // ============================================
            [
                'id' => 25,
                'category' => 'settings',
                'question' => trans('messages.faq_how_to_change_store_settings'),
                'answer' => trans('messages.faq_how_to_change_store_settings_answer'),
            ],
            [
                'id' => 26,
                'category' => 'settings',
                'question' => trans('messages.faq_how_to_configure_sku'),
                'answer' => trans('messages.faq_how_to_configure_sku_answer'),
            ],
            [
                'id' => 27,
                'category' => 'settings',
                'question' => trans('messages.faq_how_to_configure_barcode'),
                'answer' => trans('messages.faq_how_to_configure_barcode_answer'),
            ],
            
            // ============================================
            // SYSTEM MANAGEMENT
            // ============================================
            [
                'id' => 150,
                'category' => 'system-management',
                'question' => trans('messages.faq_how_to_manage_users'),
                'answer' => trans('messages.faq_how_to_manage_users_answer'),
            ],
            [
                'id' => 151,
                'category' => 'system-management',
                'question' => trans('messages.faq_how_to_backup_database'),
                'answer' => trans('messages.faq_how_to_backup_database_answer'),
            ],
            [
                'id' => 152,
                'category' => 'system-management',
                'question' => trans('messages.faq_what_is_system_management'),
                'answer' => trans('messages.faq_what_is_system_management_answer'),
            ],
        ];
    }
}
