<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class SetLocale
{
    public function handle(Request $request, Closure $next): Response
    {
        $locale = null;
        
        // أولوية: Session > User Database > Config Default
        if (Session::has('locale')) {
            $locale = Session::get('locale');
        } elseif (Auth::check() && Auth::user()->locale) {
            $locale = Auth::user()->locale;
            // تحديث Session للتوافق
            Session::put('locale', $locale);
        } else {
            $locale = config('app.locale');
        }
        
        // التأكد من أن اللغة صحيحة
        if (!in_array($locale, ['en', 'ar', 'fr'])) {
            $locale = config('app.locale');
        }
        
        App::setLocale($locale);
        
        return $next($request);
    }
}

