<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Category extends Model
{
    use HasFactory;

    protected static function newFactory()
    {
        return \Database\Factories\CategoryFactory::new();
    }

    protected $fillable = [
        'name',
        'name_ar',
        'description',
    ];

    public function products()
    {
        return $this->hasMany(Product::class);
    }
}

