<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class InvoiceItem extends Model
{
    use HasFactory;

    protected $fillable = [
        'invoice_id',
        'product_id',
        'batch_id',
        'quantity',
        'unit_price',
        'tax_rate',
        'discount',
        'subtotal',
        'total',
    ];

    protected function casts(): array
    {
        return [
            'quantity' => 'integer',
            'unit_price' => 'decimal:2',
            'tax_rate' => 'decimal:2',
            'discount' => 'decimal:2',
            'subtotal' => 'decimal:2',
            'total' => 'decimal:2',
        ];
    }

    public function invoice()
    {
        return $this->belongsTo(Invoice::class);
    }

    public function product()
    {
        return $this->belongsTo(Product::class);
    }

    public function batch()
    {
        return $this->belongsTo(ProductBatch::class);
    }

    public function calculateTotal(): void
    {
        $this->subtotal = $this->quantity * $this->unit_price;
        $afterDiscount = $this->subtotal - $this->discount;
        $taxAmount = $afterDiscount * ($this->tax_rate / 100);
        $this->total = $afterDiscount + $taxAmount;
        $this->save();
    }
}

