<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Carbon\Carbon;

class License extends Model
{
    use HasFactory;

    protected $fillable = [
        'license_key',
        'serial_number',
        'domain',
        'machine_id',
        'machine_name',
        'ip_address',
        'email',
        'customer_name',
        'status',
        'activated_at',
        'expires_at',
        'max_users',
        'notes',
    ];

    protected $casts = [
        'activated_at' => 'date',
        'expires_at' => 'date',
    ];

    /**
     * التحقق من صلاحية الترخيص
     */
    public function isValid(): bool
    {
        if ($this->status !== 'active') {
            return false;
        }

        if ($this->expires_at && Carbon::now()->greaterThan($this->expires_at)) {
            $this->update(['status' => 'expired']);
            return false;
        }

        return true;
    }

    /**
     * التحقق من انتهاء الترخيص
     */
    public function isExpired(): bool
    {
        if (!$this->expires_at) {
            return false; // ترخيص دائم
        }

        return Carbon::now()->greaterThan($this->expires_at);
    }

    /**
     * الحصول على الأيام المتبقية
     */
    public function getDaysRemaining(): ?int
    {
        if (!$this->expires_at) {
            return null; // ترخيص دائم
        }

        $days = Carbon::now()->diffInDays($this->expires_at, false);
        return $days > 0 ? $days : 0;
    }
}
