<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Supplier extends Model
{
    use HasFactory;

    protected $fillable = [
        'name',
        'phone',
        'email',
        'address',
        'notes',
    ];

    protected function casts(): array
    {
        return [
            'email' => 'string',
        ];
    }

    public function purchaseInvoices()
    {
        return $this->hasMany(PurchaseInvoice::class);
    }

    public function cheques()
    {
        return $this->hasMany(Cheque::class);
    }

    public function promissoryNotes()
    {
        return $this->hasMany(PromissoryNote::class);
    }

    public function documents()
    {
        return $this->morphMany(Document::class, 'documentable');
    }

    /**
     * Calculate the current balance for this supplier
     * Balance = total invoice amount - total paid amount
     * Only includes confirmed, partially_paid invoices (not draft, paid, or returned)
     */
    public function calculateCurrentBalance(): float
    {
        $unpaidInvoices = $this->purchaseInvoices()
            ->whereIn('status', ['confirmed', 'partially_paid'])
            ->get();

        $totalInvoiceAmount = $unpaidInvoices->sum('total_amount');
        $totalPaidAmount = $unpaidInvoices->sum('amount_paid');

        $balance = $totalInvoiceAmount - $totalPaidAmount;
        return round($balance, 2);
    }
}

