<?php

namespace App\Traits;

use Illuminate\Http\Request;

trait Sortable
{
    protected function applySorting($query, Request $request, array $allowedColumns = [], string $defaultColumn = 'created_at', string $defaultDirection = 'desc')
    {
        $sort = $request->get('sort', $defaultColumn);
        $direction = $request->get('direction', $defaultDirection);

        // Validate sort column
        if (!empty($allowedColumns) && !in_array($sort, $allowedColumns)) {
            $sort = $defaultColumn;
        }

        // Validate direction
        if (!in_array(strtolower($direction), ['asc', 'desc'])) {
            $direction = $defaultDirection;
        }

        // Handle relationship sorting
        if (str_contains($sort, '.')) {
            [$relation, $column] = explode('.', $sort, 2);
            $query->joinRelated($relation)->orderBy("{$relation}.{$column}", $direction);
        } else {
            $query->orderBy($sort, $direction);
        }

        return $query;
    }

    protected function getSortUrl($column, $currentSort, $currentDirection)
    {
        $direction = ($currentSort === $column && $currentDirection === 'asc') ? 'desc' : 'asc';
        return request()->fullUrlWithQuery(['sort' => $column, 'direction' => $direction]);
    }

    protected function getSortIcon($column, $currentSort, $currentDirection)
    {
        if ($currentSort !== $column) {
            return '<i class="bi bi-arrow-down-up text-muted"></i>';
        }
        return $currentDirection === 'asc' 
            ? '<i class="bi bi-arrow-up"></i>' 
            : '<i class="bi bi-arrow-down"></i>';
    }
}

