<?php

namespace Database\Factories;

use App\Models\Customer;
use App\Models\User;
use Illuminate\Database\Eloquent\Factories\Factory;

class InvoiceFactory extends Factory
{
    public function definition(): array
    {
        return [
            'invoice_number' => 'INV-' . str_pad($this->faker->unique()->numberBetween(1, 999999), 6, '0', STR_PAD_LEFT),
            'customer_id' => Customer::factory(),
            'customer_name' => $this->faker->name(),
            'status' => $this->faker->randomElement(['draft', 'final', 'paid', 'partially_paid']),
            'subtotal' => $this->faker->randomFloat(2, 100, 10000),
            'discount' => $this->faker->randomFloat(2, 0, 500),
            'tax' => $this->faker->randomFloat(2, 0, 1000),
            'total' => $this->faker->randomFloat(2, 100, 10000),
            'paid_amount' => $this->faker->randomFloat(2, 0, 10000),
            'due_amount' => $this->faker->randomFloat(2, 0, 5000),
            'user_id' => User::factory(),
        ];
    }
}

