<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('licenses', function (Blueprint $table) {
            $table->string('machine_id')->nullable()->after('domain');
            $table->string('machine_name')->nullable()->after('machine_id');
            $table->string('ip_address')->nullable()->after('machine_name');
            $table->index('machine_id');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('licenses', function (Blueprint $table) {
            $table->dropIndex(['machine_id']);
            $table->dropColumn(['machine_id', 'machine_name', 'ip_address']);
        });
    }
};






