<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('licenses', function (Blueprint $table) {
            $table->id();
            $table->string('license_key')->unique();
            $table->string('serial_number')->unique();
            $table->string('domain')->nullable();
            $table->string('email')->nullable();
            $table->string('customer_name')->nullable();
            $table->enum('status', ['pending', 'active', 'expired', 'suspended', 'trial'])->default('pending');
            $table->date('activated_at')->nullable();
            $table->date('expires_at')->nullable();
            $table->integer('max_users')->default(10);
            $table->text('notes')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('licenses');
    }
};
