<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    public function up(): void
    {
        // First, convert any existing 'card' payments to 'online' (similar payment method)
        DB::statement("UPDATE payments SET payment_method = 'online' WHERE payment_method = 'card'");
        
        // Then modify the enum to match supplier payments: cash, bank_transfer, credit, cheque, promissory_note, online, other
        DB::statement("ALTER TABLE payments MODIFY COLUMN payment_method ENUM('cash', 'bank_transfer', 'credit', 'cheque', 'promissory_note', 'online', 'other') DEFAULT 'cash'");
    }

    public function down(): void
    {
        // Revert back to original enum
        DB::statement("ALTER TABLE payments MODIFY COLUMN payment_method ENUM('cash', 'card', 'bank_transfer', 'cheque', 'promissory_note') DEFAULT 'cash'");
        
        // Note: We don't convert 'online' back to 'card' as we can't determine which were originally 'card'
    }
};
