<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('notifications', function (Blueprint $table) {
            $table->id();
            $table->string('type'); // low_stock, batch_expiring, invoice_due, cheque_due, promissory_note_due
            $table->string('title');
            $table->text('message');
            $table->string('severity')->default('info'); // info, warning, danger, success
            $table->string('icon')->nullable();
            $table->boolean('is_read')->default(false);
            $table->timestamp('read_at')->nullable();
            $table->string('model_type')->nullable(); // Product, ProductBatch, Invoice, Cheque, PromissoryNote
            $table->unsignedBigInteger('model_id')->nullable();
            $table->json('data')->nullable(); // Additional data
            $table->timestamps();

            $table->index(['type', 'is_read']);
            $table->index(['model_type', 'model_id']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('notifications');
    }
};
