<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('stock_takes', function (Blueprint $table) {
            $table->id();
            $table->string('reference_number')->unique(); // رقم مرجعي للجرد
            $table->date('stock_take_date'); // تاريخ الجرد
            $table->enum('status', ['draft', 'in_progress', 'completed', 'cancelled'])->default('draft');
            $table->enum('type', ['full', 'partial', 'scheduled'])->default('full'); // كامل، جزئي، مجدول
            $table->text('notes')->nullable();
            $table->foreignId('created_by')->constrained('users')->cascadeOnDelete();
            $table->foreignId('completed_by')->nullable()->constrained('users')->nullOnDelete();
            $table->timestamp('completed_at')->nullable();
            $table->timestamps();
            
            $table->index(['status', 'stock_take_date']);
        });
        
        Schema::create('stock_take_items', function (Blueprint $table) {
            $table->id();
            $table->foreignId('stock_take_id')->constrained('stock_takes')->cascadeOnDelete();
            $table->foreignId('product_id')->constrained('products')->cascadeOnDelete();
            $table->integer('system_quantity'); // الكمية في النظام
            $table->integer('counted_quantity'); // الكمية المعدودة فعلياً
            $table->integer('variance'); // الفرق (counted - system)
            $table->decimal('unit_cost', 10, 2)->nullable(); // تكلفة الوحدة
            $table->decimal('variance_value', 15, 2)->nullable(); // قيمة الفرق
            $table->text('notes')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('stock_takes');
    }
};
