<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    public function up(): void
    {
        Schema::create('product_defects', function (Blueprint $table) {
            $table->id();
            $table->foreignId('product_id')->constrained()->onDelete('cascade');
            $table->foreignId('warehouse_id')->nullable()->constrained()->onDelete('set null');
            $table->foreignId('purchase_invoice_id')->nullable()->constrained()->onDelete('set null');
            $table->foreignId('batch_id')->nullable()->constrained('product_batches')->onDelete('set null');
            $table->string('defect_number')->unique();
            $table->enum('defect_type', ['manufacturing', 'transport', 'storage', 'other'])->default('other');
            $table->string('severity')->default('medium'); // low, medium, high, critical
            $table->integer('quantity')->default(1);
            $table->text('description');
            $table->text('description_ar')->nullable();
            $table->enum('status', ['reported', 'under_review', 'resolved', 'rejected'])->default('reported');
            $table->foreignId('reported_by')->constrained('users')->onDelete('cascade');
            $table->foreignId('assigned_to')->nullable()->constrained('users')->onDelete('set null');
            $table->date('reported_date');
            $table->date('resolved_date')->nullable();
            $table->text('resolution_notes')->nullable();
            $table->text('images')->nullable(); // JSON array of image paths
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('product_defects');
    }
};
