<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Permission;
use Spatie\Permission\Models\Role;

class PermissionsSeeder extends Seeder
{
    public function run(): void
    {
        // Clear cached permissions
        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();

        // Define all permissions
        $permissions = [
            // Dashboard
            'dashboard.view',
            
            // POS
            'pos.view',
            'pos.create',
            'pos.print',
            'pos.cart.manage',
            'pos.discount.apply',
            'pos.draft.manage',
            
            // Products
            'products.view',
            'products.create',
            'products.update',
            'products.delete',
            'products.import',
            'products.export',
            'products.reports',
            'products.bulk_delete',
            
            // Categories
            'categories.view',
            'categories.create',
            'categories.update',
            'categories.delete',
            'categories.import',
            'categories.bulk_delete',
            
            // Inventories
            'inventories.view',
            'inventories.create',
            'inventories.update',
            'inventories.delete',
            'inventories.complete',
            'inventories.print',
            
            // Sales Invoices
            'invoices.view',
            'invoices.create',
            'invoices.update',
            'invoices.delete',
            'invoices.finalize',
            'invoices.return',
            'invoices.print',
            'invoices.pdf',
            'invoices.export',
            'invoices.import',
            'invoices.bulk_delete',
            
            // Purchase Invoices
            'purchase-invoices.view',
            'purchase-invoices.create',
            'purchase-invoices.update',
            'purchase-invoices.delete',
            'purchase-invoices.confirm',
            'purchase-invoices.return',
            'purchase-invoices.print',
            'purchase-invoices.pdf',
            'purchase-invoices.export',
            'purchase-invoices.import',
            'purchase-invoices.bulk_delete',
            
            // Warehouses
            'warehouses.view',
            'warehouses.create',
            'warehouses.update',
            'warehouses.delete',
            'warehouses.transfer',
            
            // Payments
            'payments.view',
            'payments.create',
            'payments.delete',
            
            // Supplier Payments
            'supplier-payments.view',
            'supplier-payments.create',
            'supplier-payments.delete',
            
            // Customers
            'customers.view',
            'customers.create',
            'customers.update',
            'customers.delete',
            'customers.import',
            'customers.export',
            'customers.bulk_delete',
            'customers.print_debts',
            
            // Suppliers
            'suppliers.view',
            'suppliers.create',
            'suppliers.update',
            'suppliers.delete',
            'suppliers.import',
            'suppliers.export',
            'suppliers.bulk_delete',
            'suppliers.print_debts',
            
            // Treasury
            'treasury.view',
            'treasury.create',
            'treasury.update',
            'treasury.delete',
            'treasury.dashboard',
            'treasury.export',
            'treasury.bulk_delete',
            
            // Cheques
            'cheques.view',
            'cheques.create',
            'cheques.update',
            'cheques.delete',
            'cheques.mark_paid',
            'cheques.mark_returned',
            'cheques.cancel',
            
            // Promissory Notes
            'promissory-notes.view',
            'promissory-notes.create',
            'promissory-notes.update',
            'promissory-notes.delete',
            'promissory-notes.mark_paid',
            'promissory-notes.cancel',
            
            // Quality Management
            'quality.defects.view',
            'quality.defects.create',
            'quality.defects.update',
            'quality.defects.delete',
            'quality.complaints.view',
            'quality.complaints.create',
            'quality.complaints.update',
            'quality.complaints.delete',
            'quality.reports.view',
            
            // Reports
            'reports.view',
            'reports.sales',
            'reports.products',
            'reports.profit',
            'reports.stock',
            'reports.cash_flow',
            'reports.cash_flow.print',
            'reports.profit_loss',
            'reports.profit_loss.print',
            'reports.balance_sheet',
            'reports.balance_sheet.print',
            'reports.cost_analysis',
            'reports.cost_analysis.print',
            'reports.suppliers',
            'reports.customers',
            'reports.export',
            
            // Analytics
            'analytics.view',
            'analytics.sales_trends',
            'analytics.sales_forecast',
            'analytics.profitability',
            'analytics.charts',
            
            // Settings
            'settings.view',
            'settings.update',
            'settings.upload_logo',
            
            // Users
            'users.view',
            'users.create',
            'users.update',
            'users.delete',
            'users.reset_password',
            
            // Permissions
            'permissions.view',
            'permissions.manage',
            'permissions.roles.create',
            'permissions.roles.update',
            'permissions.roles.delete',
            'permissions.permissions.create',
            'permissions.permissions.delete',
            
            // Activity Logs
            'activity-logs.view',
            'activity-logs.show',
            'activity-logs.delete',
            'activity-logs.clear',
            
            // Backups
            'backups.view',
            'backups.create',
            'backups.download',
            'backups.delete',
            'backups.export_sqlite',
            
            // Profile
            'profile.view',
            'profile.update',
            'profile.change_password',
            
            // User Guide
            'user-guide.view',
        ];

        // Create permissions
        foreach ($permissions as $permission) {
            Permission::firstOrCreate([
                'name' => $permission,
                'guard_name' => 'web'
            ]);
        }

        // Get roles
        $superAdmin = Role::where('name', 'Super Admin')->first();
        $admin = Role::where('name', 'Admin')->first();
        $cashier = Role::where('name', 'Cashier')->first();
        $warehouse = Role::where('name', 'Warehouse')->first();

        // Super Admin - All permissions
        if ($superAdmin) {
            $superAdmin->syncPermissions($permissions);
        }

        // Admin - All except users, permissions, backups
        if ($admin) {
            $adminPermissions = array_filter($permissions, function($perm) {
                return !str_starts_with($perm, 'users.') 
                    && !str_starts_with($perm, 'permissions.') 
                    && !str_starts_with($perm, 'backups.');
            });
            $admin->syncPermissions($adminPermissions);
        }

        // Cashier permissions
        if ($cashier) {
            $cashierPermissions = [
                'dashboard.view',
                'pos.view',
                'pos.create',
                'pos.print',
                'pos.cart.manage',
                'pos.discount.apply',
                'pos.draft.manage',
                'invoices.view',
                'invoices.create',
                'invoices.update',
                'invoices.finalize',
                'invoices.print',
                'invoices.pdf',
                'payments.view',
                'payments.create',
                'payments.delete',
                'customers.view',
                'customers.create',
                'customers.update',
                'products.view',
                'categories.view',
                'profile.view',
                'profile.update',
                'profile.change_password',
            ];
            $cashier->syncPermissions($cashierPermissions);
        }

        // Warehouse permissions
        if ($warehouse) {
            $warehousePermissions = [
                'dashboard.view',
                'products.view',
                'products.update',
                'categories.view',
                'inventories.view',
                'inventories.create',
                'inventories.update',
                'inventories.delete',
                'inventories.complete',
                'inventories.print',
                'purchase-invoices.view',
                'purchase-invoices.create',
                'purchase-invoices.update',
                'purchase-invoices.confirm',
                'warehouses.view',
                'warehouses.transfer',
                'suppliers.view',
                'profile.view',
                'profile.update',
                'profile.change_password',
            ];
            $warehouse->syncPermissions($warehousePermissions);
        }

        // Reset cached permissions
        app()[\Spatie\Permission\PermissionRegistrar::class]->forgetCachedPermissions();
    }
}
