<?php

namespace Database\Seeders;

use App\Models\Category;
use App\Models\Product;
use Illuminate\Database\Seeder;

class ProductSeeder extends Seeder
{
    public function run(): void
    {
        $categories = Category::all();
        
        $products = [
            ['sku' => 'PROD001', 'name' => 'Laptop', 'name_ar' => 'لابتوب', 'purchase_price' => 500, 'selling_price' => 750, 'stock_quantity' => 10, 'reorder_level' => 5],
            ['sku' => 'PROD002', 'name' => 'Mouse', 'name_ar' => 'فأرة', 'purchase_price' => 10, 'selling_price' => 15, 'stock_quantity' => 50, 'reorder_level' => 20],
            ['sku' => 'PROD003', 'name' => 'Keyboard', 'name_ar' => 'لوحة مفاتيح', 'purchase_price' => 25, 'selling_price' => 40, 'stock_quantity' => 30, 'reorder_level' => 15],
            ['sku' => 'PROD004', 'name' => 'Monitor', 'name_ar' => 'شاشة', 'purchase_price' => 150, 'selling_price' => 220, 'stock_quantity' => 15, 'reorder_level' => 5],
            ['sku' => 'PROD005', 'name' => 'Headphones', 'name_ar' => 'سماعات', 'purchase_price' => 30, 'selling_price' => 50, 'stock_quantity' => 40, 'reorder_level' => 20],
            ['sku' => 'PROD006', 'name' => 'T-Shirt', 'name_ar' => 'قميص', 'purchase_price' => 15, 'selling_price' => 25, 'stock_quantity' => 100, 'reorder_level' => 50],
            ['sku' => 'PROD007', 'name' => 'Jeans', 'name_ar' => 'بنطلون', 'purchase_price' => 40, 'selling_price' => 70, 'stock_quantity' => 60, 'reorder_level' => 30],
            ['sku' => 'PROD008', 'name' => 'Shoes', 'name_ar' => 'أحذية', 'purchase_price' => 50, 'selling_price' => 90, 'stock_quantity' => 45, 'reorder_level' => 20],
            ['sku' => 'PROD009', 'name' => 'Coffee', 'name_ar' => 'قهوة', 'purchase_price' => 8, 'selling_price' => 12, 'stock_quantity' => 200, 'reorder_level' => 100],
            ['sku' => 'PROD010', 'name' => 'Tea', 'name_ar' => 'شاي', 'purchase_price' => 5, 'selling_price' => 8, 'stock_quantity' => 150, 'reorder_level' => 75],
            ['sku' => 'PROD011', 'name' => 'Table', 'name_ar' => 'طاولة', 'purchase_price' => 100, 'selling_price' => 150, 'stock_quantity' => 20, 'reorder_level' => 10],
            ['sku' => 'PROD012', 'name' => 'Chair', 'name_ar' => 'كرسي', 'purchase_price' => 60, 'selling_price' => 90, 'stock_quantity' => 35, 'reorder_level' => 15],
            ['sku' => 'PROD013', 'name' => 'Sofa', 'name_ar' => 'أريكة', 'purchase_price' => 300, 'selling_price' => 450, 'stock_quantity' => 8, 'reorder_level' => 3],
            ['sku' => 'PROD014', 'name' => 'Football', 'name_ar' => 'كرة قدم', 'purchase_price' => 20, 'selling_price' => 35, 'stock_quantity' => 50, 'reorder_level' => 25],
            ['sku' => 'PROD015', 'name' => 'Basketball', 'name_ar' => 'كرة سلة', 'purchase_price' => 25, 'selling_price' => 40, 'stock_quantity' => 40, 'reorder_level' => 20],
            ['sku' => 'PROD016', 'name' => 'Phone', 'name_ar' => 'هاتف', 'purchase_price' => 200, 'selling_price' => 300, 'stock_quantity' => 25, 'reorder_level' => 10],
            ['sku' => 'PROD017', 'name' => 'Tablet', 'name_ar' => 'تابلت', 'purchase_price' => 150, 'selling_price' => 220, 'stock_quantity' => 18, 'reorder_level' => 8],
            ['sku' => 'PROD018', 'name' => 'Camera', 'name_ar' => 'كاميرا', 'purchase_price' => 400, 'selling_price' => 600, 'stock_quantity' => 12, 'reorder_level' => 5],
            ['sku' => 'PROD019', 'name' => 'Printer', 'name_ar' => 'طابعة', 'purchase_price' => 120, 'selling_price' => 180, 'stock_quantity' => 15, 'reorder_level' => 7],
            ['sku' => 'PROD020', 'name' => 'Scanner', 'name_ar' => 'ماسح ضوئي', 'purchase_price' => 80, 'selling_price' => 120, 'stock_quantity' => 22, 'reorder_level' => 10],
        ];

        foreach ($products as $index => $product) {
            $category = $categories->random();
            Product::firstOrCreate(
                ['sku' => $product['sku']],
                array_merge($product, [
                    'category_id' => $category->id,
                    'unit' => 'piece',
                    'tax_rate' => 10,
                ])
            );
        }
    }
}

