<?php

namespace Database\Seeders;

use App\Models\Supplier;
use Illuminate\Database\Seeder;

class SupplierSeeder extends Seeder
{
    public function run(): void
    {
        $suppliers = [
            ['name' => 'ABC Suppliers', 'email' => 'abc@supplier.com', 'phone' => '1234567890'],
            ['name' => 'XYZ Trading', 'email' => 'xyz@trading.com', 'phone' => '0987654321'],
            ['name' => 'Global Imports', 'email' => 'global@imports.com', 'phone' => '1122334455'],
            ['name' => 'Local Distributors', 'email' => 'local@dist.com', 'phone' => '5566778899'],
            ['name' => 'Premium Goods Co', 'email' => 'premium@goods.com', 'phone' => '9988776655'],
        ];

        foreach ($suppliers as $supplier) {
            Supplier::firstOrCreate(['email' => $supplier['email']], $supplier);
        }
    }
}

