@extends('layouts.master')

@section('title', trans('messages.activity_logs'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.activity_logs') }}</h2>
    @if(auth()->user()->hasRole('Super Admin'))
    <button type="button" class="btn btn-danger" data-bs-toggle="modal" data-bs-target="#clearLogsModal">
        <i class="bi bi-trash"></i> {{ trans('messages.clear_logs') }}
    </button>
    @endif
</div>

<div class="card mb-3">
    <div class="card-body">
        <form method="GET" action="{{ route('activity-logs.index') }}">
            <div class="row g-3">
                <div class="col-md-3">
                    <label for="user_id" class="form-label">{{ trans('messages.user') }}</label>
                    <select name="user_id" class="form-select">
                        <option value="">{{ trans('messages.all_users') }}</option>
                        @foreach($users as $user)
                        <option value="{{ $user->id }}" {{ request('user_id') == $user->id ? 'selected' : '' }}>
                            {{ $user->name }}
                        </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-2">
                    <label for="action" class="form-label">{{ trans('messages.action') }}</label>
                    <select name="action" class="form-select">
                        <option value="">{{ trans('messages.all_actions') }}</option>
                        @foreach($actions as $action)
                        <option value="{{ $action }}" {{ request('action') == $action ? 'selected' : '' }}>
                            {{ trans('messages.' . $action) }}
                        </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-3">
                    <label for="model_type" class="form-label">{{ trans('messages.model_type') }}</label>
                    <select name="model_type" class="form-select">
                        <option value="">{{ trans('messages.all_types') }}</option>
                        @foreach($modelTypes as $modelType)
                        <option value="{{ $modelType }}" {{ request('model_type') == $modelType ? 'selected' : '' }}>
                            {{ class_basename($modelType) }}
                        </option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-2">
                    <label for="date_from" class="form-label">{{ trans('messages.from_date') }}</label>
                    <input type="date" name="date_from" class="form-control" value="{{ request('date_from') }}">
                </div>
                <div class="col-md-2">
                    <label for="date_to" class="form-label">{{ trans('messages.to_date') }}</label>
                    <input type="date" name="date_to" class="form-control" value="{{ request('date_to') }}">
                </div>
                <div class="col-md-12">
                    <div class="input-group">
                        <input type="text" name="search" class="form-control" placeholder="{{ trans('messages.search') }}..." value="{{ request('search') }}">
                        <button type="submit" class="btn btn-primary">{{ trans('messages.filter') }}</button>
                        <a href="{{ route('activity-logs.index') }}" class="btn btn-secondary">{{ trans('messages.reset') }}</a>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="card">
    <div class="card-body">
        <div class="table-responsive">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>{{ trans('messages.date_time') }}</th>
                        <th>{{ trans('messages.user') }}</th>
                        <th>{{ trans('messages.action') }}</th>
                        <th>{{ trans('messages.description') }}</th>
                        <th>{{ trans('messages.model') }}</th>
                        <th>{{ trans('messages.ip_address') }}</th>
                        <th>{{ trans('messages.actions') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($logs as $log)
                    <tr>
                        <td>{{ $log->created_at->format('Y-m-d H:i:s') }}</td>
                        <td>
                            @if($log->user)
                                <a href="{{ route('users.show', $log->user) }}">{{ $log->user->name }}</a>
                            @else
                                <span class="text-muted">-</span>
                            @endif
                        </td>
                        <td>
                            <span class="badge bg-{{ $log->action_badge }}">
                                {{ trans('messages.' . $log->action) }}
                            </span>
                        </td>
                        <td>{{ $log->description }}</td>
                        <td>
                            @if($log->model_type)
                                <small>{{ class_basename($log->model_type) }}</small>
                                @if($log->model_id)
                                    <span class="badge bg-secondary">#{{ $log->model_id }}</span>
                                @endif
                            @else
                                <span class="text-muted">-</span>
                            @endif
                        </td>
                        <td><small>{{ $log->ip_address }}</small></td>
                        <td>
                            <a href="{{ route('activity-logs.show', $log) }}" class="btn btn-sm btn-info">
                                <i class="bi bi-eye"></i>
                            </a>
                            @if(auth()->user()->hasRole('Super Admin'))
                            <form method="POST" action="{{ route('activity-logs.destroy', $log) }}" class="d-inline" onsubmit="return confirm('{{ trans('messages.confirm_delete') }}');">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="btn btn-sm btn-danger">
                                    <i class="bi bi-trash"></i>
                                </button>
                            </form>
                            @endif
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="7" class="text-center">{{ trans('messages.no_activity_logs_found') }}</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        <div class="mt-3">
            {{ $logs->links() }}
        </div>
    </div>
</div>

<!-- Clear Logs Modal -->
@if(auth()->user()->hasRole('Super Admin'))
<div class="modal fade" id="clearLogsModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title">{{ trans('messages.clear_logs') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
            </div>
            <form method="POST" action="{{ route('activity-logs.clear') }}">
                @csrf
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="date_before" class="form-label">{{ trans('messages.delete_logs_before') }}</label>
                        <input type="date" name="date_before" class="form-control" required>
                        <small class="text-muted">{{ trans('messages.clear_logs_warning') }}</small>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ trans('messages.cancel') }}</button>
                    <button type="submit" class="btn btn-danger">{{ trans('messages.clear') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endif
@endsection

