@extends('layouts.master')

@section('title', trans('messages.interactive_charts'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.interactive_charts') }}</h2>
    <div>
        <button onclick="window.print()" class="btn btn-primary">
            <i class="bi bi-printer"></i> {{ trans('messages.print_report') }}
        </button>
        <a href="{{ route('analytics.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> {{ trans('messages.back') }}
        </a>
    </div>
</div>

<div class="card mb-3">
    <div class="card-body">
        <form method="GET" action="{{ route('analytics.charts') }}">
            <div class="row g-3">
                <div class="col-md-4">
                    <label for="date_from" class="form-label">{{ trans('messages.from_date') }}</label>
                    <input type="date" name="date_from" class="form-control" value="{{ $dateFrom }}">
                </div>
                <div class="col-md-4">
                    <label for="date_to" class="form-label">{{ trans('messages.to_date') }}</label>
                    <input type="date" name="date_to" class="form-control" value="{{ $dateTo }}">
                </div>
                <div class="col-md-4">
                    <label class="form-label">&nbsp;</label>
                    <button type="submit" class="btn btn-primary w-100 d-block">{{ trans('messages.filter') }}</button>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="row g-3 mb-4">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.sales_vs_purchases') }}</h5>
            </div>
            <div class="card-body">
                <canvas id="salesVsPurchasesChart" height="80"></canvas>
            </div>
        </div>
    </div>
</div>

<div class="row g-3 mb-4">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.sales_by_payment_method') }}</h5>
            </div>
            <div class="card-body">
                <canvas id="paymentMethodChart" height="300"></canvas>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.top_products') }}</h5>
            </div>
            <div class="card-body">
                <canvas id="topProductsChart" height="300"></canvas>
            </div>
        </div>
    </div>
</div>

<div class="row g-3 mb-4">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.daily') }} {{ trans('messages.sales') }}</h5>
            </div>
            <div class="card-body">
                <canvas id="dailySalesChart" height="80"></canvas>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
// Sales vs Purchases Chart
const salesDates = @json($salesData->pluck('date')->toArray());
const salesValues = @json($salesData->pluck('total')->toArray());
const purchaseDates = @json($purchasesData->pluck('date')->toArray());
const purchaseValues = @json($purchasesData->pluck('total')->toArray());

// Combine all dates
const allDates = [...new Set([...salesDates, ...purchaseDates])].sort();
const salesVsPurchasesCtx = document.getElementById('salesVsPurchasesChart').getContext('2d');
const salesVsPurchasesChart = new Chart(salesVsPurchasesCtx, {
    type: 'line',
    data: {
        labels: allDates,
        datasets: [{
            label: '{{ trans('messages.sales') }}',
            data: allDates.map(date => {
                const index = salesDates.indexOf(date);
                return index !== -1 ? salesValues[index] : null;
            }),
            borderColor: 'rgb(75, 192, 192)',
            backgroundColor: 'rgba(75, 192, 192, 0.2)',
            tension: 0.1
        }, {
            label: '{{ trans('messages.purchases') }}',
            data: allDates.map(date => {
                const index = purchaseDates.indexOf(date);
                return index !== -1 ? purchaseValues[index] : null;
            }),
            borderColor: 'rgb(255, 99, 132)',
            backgroundColor: 'rgba(255, 99, 132, 0.2)',
            tension: 0.1
        }]
    },
    options: {
        responsive: true,
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});

// Payment Method Chart
const paymentMethodCtx = document.getElementById('paymentMethodChart').getContext('2d');
const paymentMethodChart = new Chart(paymentMethodCtx, {
    type: 'doughnut',
    data: {
        labels: @json($paymentMethodSales->pluck('payment_method')->toArray()),
        datasets: [{
            data: @json($paymentMethodSales->pluck('total')->toArray()),
            backgroundColor: [
                'rgba(255, 99, 132, 0.6)',
                'rgba(54, 162, 235, 0.6)',
                'rgba(255, 206, 86, 0.6)',
                'rgba(75, 192, 192, 0.6)'
            ]
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false
    }
});

// Top Products Chart
const topProductsCtx = document.getElementById('topProductsChart').getContext('2d');
const topProductsChart = new Chart(topProductsCtx, {
    type: 'bar',
    data: {
        labels: @json($topProducts->pluck('product.name')->toArray()),
        datasets: [{
            label: '{{ trans('messages.quantity_sold') }}',
            data: @json($topProducts->pluck('total_quantity')->toArray()),
            backgroundColor: 'rgba(54, 162, 235, 0.6)'
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false,
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});

// Daily Sales Chart
const dailySalesCtx = document.getElementById('dailySalesChart').getContext('2d');
const dailySalesChart = new Chart(dailySalesCtx, {
    type: 'bar',
    data: {
        labels: @json($dailySales->pluck('date')->toArray()),
        datasets: [{
            label: '{{ trans('messages.total_sales') }}',
            data: @json($dailySales->pluck('total')->toArray()),
            backgroundColor: 'rgba(75, 192, 192, 0.6)'
        }, {
            label: '{{ trans('messages.invoice_count') }}',
            data: @json($dailySales->pluck('count')->toArray()),
            backgroundColor: 'rgba(255, 99, 132, 0.6)',
            yAxisID: 'y1'
        }]
    },
    options: {
        responsive: true,
        scales: {
            y: {
                type: 'linear',
                display: true,
                position: 'left',
            },
            y1: {
                type: 'linear',
                display: true,
                position: 'right',
                grid: {
                    drawOnChartArea: false,
                },
            },
        }
    }
});
</script>
@endpush

@push('styles')
<style>
@media print {
    .page-header, .card.mb-3:first-of-type, .btn {
        display: none !important;
    }
    .card {
        border: none;
        box-shadow: none;
    }
}
</style>
@endpush
@endsection

