@extends('layouts.master')

@section('title', trans('messages.profitability_analysis'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.profitability_analysis') }}</h2>
    <div>
        <button onclick="window.print()" class="btn btn-primary">
            <i class="bi bi-printer"></i> {{ trans('messages.print_report') }}
        </button>
        <a href="{{ route('analytics.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> {{ trans('messages.back') }}
        </a>
    </div>
</div>

<div class="card mb-3">
    <div class="card-body">
        <form method="GET" action="{{ route('analytics.profitability') }}">
            <div class="row g-3">
                <div class="col-md-4">
                    <label for="date_from" class="form-label">{{ trans('messages.from_date') }}</label>
                    <input type="date" name="date_from" class="form-control" value="{{ $dateFrom }}">
                </div>
                <div class="col-md-4">
                    <label for="date_to" class="form-label">{{ trans('messages.to_date') }}</label>
                    <input type="date" name="date_to" class="form-control" value="{{ $dateTo }}">
                </div>
                <div class="col-md-4">
                    <label class="form-label">&nbsp;</label>
                    <button type="submit" class="btn btn-primary w-100 d-block">{{ trans('messages.filter') }}</button>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="row g-3 mb-4">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.monthly_profitability') }}</h5>
            </div>
            <div class="card-body">
                <canvas id="monthlyProfitabilityChart" height="80"></canvas>
            </div>
        </div>
    </div>
</div>

<div class="row g-3 mb-4">
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.product_profitability') }}</h5>
            </div>
            <div class="card-body">
                <canvas id="productProfitabilityChart" height="300"></canvas>
            </div>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.category_profitability') }}</h5>
            </div>
            <div class="card-body">
                <canvas id="categoryProfitabilityChart" height="300"></canvas>
            </div>
        </div>
    </div>
</div>

<div class="row g-3">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.product_profitability') }}</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>{{ trans('messages.product') }}</th>
                                <th class="text-end">{{ trans('messages.quantity_sold') }}</th>
                                <th class="text-end">{{ trans('messages.total_revenue') }}</th>
                                <th class="text-end">{{ trans('messages.total_cost') }}</th>
                                <th class="text-end">{{ trans('messages.profit') }}</th>
                                <th class="text-end">{{ trans('messages.profit_margin') }} %</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($productProfitability as $item)
                            <tr>
                                <td>
                                    <a href="{{ route('products.show', $item['product']->id) }}">
                                        {{ $item['product']->name }}
                                    </a>
                                </td>
                                <td class="text-end">{{ $item['quantity'] }}</td>
                                <td class="text-end">{{ format_currency($item['revenue']) }}</td>
                                <td class="text-end">{{ format_currency($item['cost']) }}</td>
                                <td class="text-end {{ $item['profit'] >= 0 ? 'text-success' : 'text-danger' }}">
                                    {{ format_currency($item['profit']) }}
                                </td>
                                <td class="text-end">{{ number_format($item['margin'], 2) }}%</td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="6" class="text-center">{{ trans('messages.no_data') }}</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
// Monthly Profitability Chart
const monthlyProfitabilityCtx = document.getElementById('monthlyProfitabilityChart').getContext('2d');
const monthlyProfitabilityChart = new Chart(monthlyProfitabilityCtx, {
    type: 'bar',
    data: {
        labels: @json($monthlyLabels),
        datasets: [{
            label: '{{ trans('messages.total_revenue') }}',
            data: @json($monthlyRevenue),
            backgroundColor: 'rgba(75, 192, 192, 0.6)'
        }, {
            label: '{{ trans('messages.total_cost') }}',
            data: @json($monthlyCost),
            backgroundColor: 'rgba(255, 99, 132, 0.6)'
        }, {
            label: '{{ trans('messages.profit') }}',
            data: @json($monthlyProfitData),
            backgroundColor: 'rgba(54, 162, 235, 0.6)'
        }]
    },
    options: {
        responsive: true,
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});

// Product Profitability Chart (Top 10)
const topProducts = @json($productProfitability->take(10)->values());
const productProfitabilityCtx = document.getElementById('productProfitabilityChart').getContext('2d');
const productProfitabilityChart = new Chart(productProfitabilityCtx, {
    type: 'doughnut',
    data: {
        labels: topProducts.map(p => p.product.name),
        datasets: [{
            data: topProducts.map(p => p.profit),
            backgroundColor: [
                'rgba(255, 99, 132, 0.6)',
                'rgba(54, 162, 235, 0.6)',
                'rgba(255, 206, 86, 0.6)',
                'rgba(75, 192, 192, 0.6)',
                'rgba(153, 102, 255, 0.6)',
                'rgba(255, 159, 64, 0.6)',
                'rgba(199, 199, 199, 0.6)',
                'rgba(83, 102, 255, 0.6)',
                'rgba(255, 99, 255, 0.6)',
                'rgba(99, 255, 132, 0.6)'
            ]
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false
    }
});

// Category Profitability Chart
const categories = @json($categoryProfitability->take(10)->values());
const categoryProfitabilityCtx = document.getElementById('categoryProfitabilityChart').getContext('2d');
const categoryProfitabilityChart = new Chart(categoryProfitabilityCtx, {
    type: 'pie',
    data: {
        labels: categories.map(c => c.category ? c.category.name : '{{ trans('messages.uncategorized') }}'),
        datasets: [{
            data: categories.map(c => c.profit),
            backgroundColor: [
                'rgba(255, 99, 132, 0.6)',
                'rgba(54, 162, 235, 0.6)',
                'rgba(255, 206, 86, 0.6)',
                'rgba(75, 192, 192, 0.6)',
                'rgba(153, 102, 255, 0.6)',
                'rgba(255, 159, 64, 0.6)',
                'rgba(199, 199, 199, 0.6)',
                'rgba(83, 102, 255, 0.6)',
                'rgba(255, 99, 255, 0.6)',
                'rgba(99, 255, 132, 0.6)'
            ]
        }]
    },
    options: {
        responsive: true,
        maintainAspectRatio: false
    }
});
</script>
@endpush

@push('styles')
<style>
@media print {
    .page-header, .card.mb-3:first-of-type, .btn {
        display: none !important;
    }
    .card {
        border: none;
        box-shadow: none;
    }
}
</style>
@endpush
@endsection

