@extends('layouts.master')

@section('title', trans('messages.sales_forecast'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.sales_forecast') }}</h2>
    <div>
        <button onclick="window.print()" class="btn btn-primary">
            <i class="bi bi-printer"></i> {{ trans('messages.print_report') }}
        </button>
        <a href="{{ route('analytics.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> {{ trans('messages.back') }}
        </a>
    </div>
</div>

<div class="card mb-3">
    <div class="card-body">
        <form method="GET" action="{{ route('analytics.sales-forecast') }}">
            <div class="row g-3">
                <div class="col-md-4">
                    <label for="months" class="form-label">{{ trans('messages.months') }} ({{ trans('messages.historical_data') }})</label>
                    <input type="number" name="months" class="form-control" value="{{ $months }}" min="3" max="24">
                </div>
                <div class="col-md-4">
                    <label for="forecast_periods" class="form-label">{{ trans('messages.forecast_periods') }}</label>
                    <input type="number" name="forecast_periods" class="form-control" value="{{ $forecastPeriods }}" min="1" max="12">
                </div>
                <div class="col-md-4">
                    <label class="form-label">&nbsp;</label>
                    <button type="submit" class="btn btn-primary w-100 d-block">{{ trans('messages.filter') }}</button>
                </div>
            </div>
        </form>
    </div>
</div>

<div class="row g-3 mb-4">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.sales_forecast') }}</h5>
            </div>
            <div class="card-body">
                <canvas id="salesForecastChart" height="80"></canvas>
            </div>
        </div>
    </div>
</div>

<div class="row g-3 mb-4">
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.invoice_count') }} {{ trans('messages.forecast') }}</h5>
            </div>
            <div class="card-body">
                <canvas id="countForecastChart" height="80"></canvas>
            </div>
        </div>
    </div>
</div>

@push('scripts')
<script>
const allLabels = @json(array_merge($labels, $forecastLabels));
const allSales = @json(array_merge($salesValues, $forecastSales));
const allCounts = @json(array_merge($countValues, $forecastCount));
const historicalLength = {{ count($labels) }};

const salesForecastCtx = document.getElementById('salesForecastChart').getContext('2d');
const salesForecastChart = new Chart(salesForecastCtx, {
    type: 'line',
    data: {
        labels: allLabels,
        datasets: [{
            label: '{{ trans('messages.historical_data') }}',
            data: allSales.map((v, i) => i < historicalLength ? v : null),
            borderColor: 'rgb(75, 192, 192)',
            backgroundColor: 'rgba(75, 192, 192, 0.2)',
            tension: 0.1
        }, {
            label: '{{ trans('messages.forecasted_data') }}',
            data: allSales.map((v, i) => i >= historicalLength ? v : null),
            borderColor: 'rgb(255, 99, 132)',
            backgroundColor: 'rgba(255, 99, 132, 0.2)',
            borderDash: [5, 5],
            tension: 0.1
        }]
    },
    options: {
        responsive: true,
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});

const countForecastCtx = document.getElementById('countForecastChart').getContext('2d');
const countForecastChart = new Chart(countForecastCtx, {
    type: 'line',
    data: {
        labels: allLabels,
        datasets: [{
            label: '{{ trans('messages.historical_data') }}',
            data: allCounts.map((v, i) => i < historicalLength ? v : null),
            borderColor: 'rgb(54, 162, 235)',
            backgroundColor: 'rgba(54, 162, 235, 0.2)',
            tension: 0.1
        }, {
            label: '{{ trans('messages.forecasted_data') }}',
            data: allCounts.map((v, i) => i >= historicalLength ? v : null),
            borderColor: 'rgb(255, 159, 64)',
            backgroundColor: 'rgba(255, 159, 64, 0.2)',
            borderDash: [5, 5],
            tension: 0.1
        }]
    },
    options: {
        responsive: true,
        scales: {
            y: {
                beginAtZero: true
            }
        }
    }
});
</script>
@endpush

@push('styles')
<style>
@media print {
    .page-header, .card.mb-3:first-of-type, .btn {
        display: none !important;
    }
    .card {
        border: none;
        box-shadow: none;
    }
}
</style>
@endpush
@endsection

