@extends('layouts.master')

@section('title', trans('messages.categories'))

@section('content')
@php
    $sort = request()->get('sort', 'created_at');
    $direction = request()->get('direction', 'desc');
@endphp
<div class="page-header">
    <h2>{{ trans('messages.categories') }}</h2>
    <div>
        @can('categories.import')
            <a href="{{ route('categories.import') }}" class="btn btn-success"><i class="bi bi-upload"></i> {{ trans('messages.import_categories') }}</a>
        @endcan
        @can('categories.create')
            <button type="button" class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#createModal"><i class="bi bi-plus-circle"></i> {{ trans('messages.add_category') }}</button>
        @endcan
    </div>
</div>

<div class="card">
    <div class="card-body">
        @can('categories.bulk_delete')
        <div class="mb-3">
            <button type="button" id="delete-selected-btn" class="btn btn-danger" disabled data-bs-toggle="modal" data-bs-target="#bulkDeleteModal">
                <i class="bi bi-trash"></i> {{ trans('messages.delete_selected') }}
            </button>
        </div>
        @endcan

        <div class="table-responsive">
            <table class="table table-hover">
                    <thead>
                        <tr>
                            @can('categories.bulk_delete')
                            <th style="width: 40px;">
                                <input type="checkbox" id="select-all" title="{{ trans('messages.select_all') }}">
                            </th>
                            @endcan
                            <th>
                                <a href="{{ request()->fullUrlWithQuery(['sort' => 'name', 'direction' => ($sort === 'name' && $direction === 'asc') ? 'desc' : 'asc']) }}" class="text-decoration-none text-dark">
                                    {{ trans('messages.name') }}
                                    @if($sort === 'name')
                                        <i class="bi bi-arrow-{{ $direction === 'asc' ? 'up' : 'down' }}"></i>
                                    @else
                                        <i class="bi bi-arrow-down-up text-muted"></i>
                                    @endif
                                </a>
                            </th>
                            <th>{{ trans('messages.name_ar') }}</th>
                            <th>
                                <a href="{{ request()->fullUrlWithQuery(['sort' => 'products_count', 'direction' => ($sort === 'products_count' && $direction === 'asc') ? 'desc' : 'asc']) }}" class="text-decoration-none text-dark">
                                    {{ trans('messages.products') }} {{ trans('messages.quantity') }}
                                    @if($sort === 'products_count')
                                        <i class="bi bi-arrow-{{ $direction === 'asc' ? 'up' : 'down' }}"></i>
                                    @else
                                        <i class="bi bi-arrow-down-up text-muted"></i>
                                    @endif
                                </a>
                            </th>
                            <th>
                                <a href="{{ request()->fullUrlWithQuery(['sort' => 'created_at', 'direction' => ($sort === 'created_at' && $direction === 'asc') ? 'desc' : 'asc']) }}" class="text-decoration-none text-dark">
                                    {{ trans('messages.date') }}
                                    @if($sort === 'created_at')
                                        <i class="bi bi-arrow-{{ $direction === 'asc' ? 'up' : 'down' }}"></i>
                                    @else
                                        <i class="bi bi-arrow-down-up text-muted"></i>
                                    @endif
                                </a>
                            </th>
                            <th>{{ trans('messages.actions') }}</th>
                        </tr>
                    </thead>
                    <tbody>
                        @forelse($categories as $category)
                        <tr>
                            @can('categories.bulk_delete')
                            <td>
                                <input type="checkbox" class="item-checkbox" value="{{ $category->id }}">
                            </td>
                            @endcan
                            <td>{{ $category->name }}</td>
                            <td>{{ $category->name_ar ?? 'N/A' }}</td>
                            <td>{{ $category->products_count }}</td>
                            <td>{{ $category->created_at->format('Y-m-d') }}</td>
                            <td>
                                @can('categories.update')
                                    <button type="button" class="btn btn-sm btn-warning" data-bs-toggle="modal" data-bs-target="#editModal{{ $category->id }}" title="{{ trans('messages.edit') }}"><i class="bi bi-pencil"></i></button>
                                @endcan
                                @can('categories.delete')
                                    <form action="{{ route('categories.destroy', $category) }}" method="POST" class="d-inline delete-form">
                                        @csrf
                                        @method('DELETE')
                                        <button type="submit" class="btn btn-sm btn-danger" title="{{ trans('messages.delete') }}" onclick="event.preventDefault(); confirmAction('{{ trans('messages.confirm_delete_category') }}', '{{ trans('messages.confirm_delete') }}', () => this.closest('form').submit()); return false;"><i class="bi bi-trash"></i></button>
                                    </form>
                                @endcan
                            </td>
                        </tr>
                        @empty
                        <tr>
                            <td colspan="{{ auth()->user()->can('categories.bulk_delete') ? '6' : '5' }}" class="text-center">{{ trans('messages.no_categories_found') }}</td>
                        </tr>
                        @endforelse
                </tbody>
            </table>
        </div>

        <!-- Hidden form for bulk delete -->
        <form id="bulk-delete-form" method="POST" action="{{ route('categories.bulk_delete') }}" style="display: none;">
            @csrf
        </form>

        {{ $categories->links() }}
    </div>
</div>

@include('partials.bulk-delete-modal')

<!-- Create Modal -->
<div class="modal fade" id="createModal" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="POST" action="{{ route('categories.store') }}">
                @csrf
                <div class="modal-header">
                    <h5 class="modal-title">{{ trans('messages.create_category') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="name" class="form-label">{{ trans('messages.name') }} *</label>
                        <input type="text" class="form-control" id="name" name="name" required>
                    </div>
                    <div class="mb-3">
                        <label for="name_ar" class="form-label">{{ trans('messages.name_ar') }}</label>
                        <input type="text" class="form-control" id="name_ar" name="name_ar">
                    </div>
                    <div class="mb-3">
                        <label for="description" class="form-label">{{ trans('messages.description') }}</label>
                        <textarea class="form-control" id="description" name="description" rows="3"></textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ trans('messages.cancel') }}</button>
                    <button type="submit" class="btn btn-primary">{{ trans('messages.create') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>

<!-- Edit Modals -->
@foreach($categories as $category)
<div class="modal fade" id="editModal{{ $category->id }}" tabindex="-1">
    <div class="modal-dialog">
        <div class="modal-content">
            <form method="POST" action="{{ route('categories.update', $category) }}">
                @csrf
                @method('PUT')
                <div class="modal-header">
                    <h5 class="modal-title">{{ trans('messages.edit_category') }}</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="name{{ $category->id }}" class="form-label">{{ trans('messages.name') }} *</label>
                        <input type="text" class="form-control" id="name{{ $category->id }}" name="name" value="{{ $category->name }}" required>
                    </div>
                    <div class="mb-3">
                        <label for="name_ar{{ $category->id }}" class="form-label">{{ trans('messages.name_ar') }}</label>
                        <input type="text" class="form-control" id="name_ar{{ $category->id }}" name="name_ar" value="{{ $category->name_ar }}">
                    </div>
                    <div class="mb-3">
                        <label for="description{{ $category->id }}" class="form-label">{{ trans('messages.description') }}</label>
                        <textarea class="form-control" id="description{{ $category->id }}" name="description" rows="3">{{ $category->description }}</textarea>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ trans('messages.cancel') }}</button>
                    <button type="submit" class="btn btn-primary">{{ trans('messages.update') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>
@endforeach
@endsection
