@extends('layouts.master')

@section('title', trans('messages.customer_details'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.customer') }}: {{ $customer->name }}</h2>
    <div>
        <a href="{{ route('customers.edit', $customer) }}" class="btn btn-warning"><i class="bi bi-pencil"></i> {{ trans('messages.edit') }}</a>
        <a href="{{ route('customers.index') }}" class="btn btn-secondary">{{ trans('messages.back') }}</a>
    </div>
</div>

<div class="row">
    <div class="col-md-4">
        <div class="card mb-3">
            <div class="card-body">
                <h5>{{ trans('messages.customer_details') }}</h5>
                <p><strong>{{ trans('messages.name') }}:</strong> {{ $customer->name }}</p>
                <p><strong>{{ trans('messages.email') }}:</strong> {{ $customer->email ?? 'N/A' }}</p>
                <p><strong>{{ trans('messages.phone') }}:</strong> {{ $customer->phone ?? 'N/A' }}</p>
                <p><strong>{{ trans('messages.address') }}:</strong> {{ $customer->address ?? 'N/A' }}</p>
                <p><strong>{{ trans('messages.current_balance') }}:</strong> 
                    @php
                        $balance = $customer->calculated_balance ?? $customer->calculateCurrentBalance();
                    @endphp
                    <span class="badge {{ $balance <= 0 ? 'text-success bg-light' : 'text-danger bg-light' }}">
                        {{ format_currency($balance) }}
                    </span>
                </p>
            </div>
        </div>

        <!-- Purchase Statistics -->
        <div class="card">
            <div class="card-header bg-primary text-white">
                <h6 class="mb-0"><i class="bi bi-graph-up"></i> {{ trans('messages.purchase_statistics') }}</h6>
            </div>
            <div class="card-body">
                <div class="mb-2">
                    <small class="text-muted">{{ trans('messages.total_purchases') }}</small>
                    <h5 class="mb-0">{{ format_currency($totalPurchases ?? 0) }}</h5>
                </div>
                <div class="mb-2">
                    <small class="text-muted">{{ trans('messages.total_paid') }}</small>
                    <h5 class="mb-0 text-success">{{ format_currency($totalPaid ?? 0) }}</h5>
                </div>
                <div class="mb-2">
                    <small class="text-muted">{{ trans('messages.total_due') }}</small>
                    <h5 class="mb-0 text-danger">{{ format_currency($totalDue ?? 0) }}</h5>
                </div>
                <hr>
                <div class="mb-2">
                    <small class="text-muted">{{ trans('messages.invoice_count') }}</small>
                    <h5 class="mb-0">{{ $invoiceCount ?? 0 }}</h5>
                </div>
                <div class="mb-2">
                    <small class="text-muted">{{ trans('messages.average_purchase') }}</small>
                    <h5 class="mb-0">{{ format_currency($averagePurchase ?? 0) }}</h5>
                </div>
                @if(isset($totalProfit))
                <hr>
                <div class="mb-2">
                    <small class="text-muted">{{ trans('messages.total_profit') }}</small>
                    <h5 class="mb-0 {{ ($totalProfit ?? 0) >= 0 ? 'text-success' : 'text-danger' }}">
                        {{ format_currency($totalProfit ?? 0) }}
                    </h5>
                </div>
                <div class="mb-0">
                    <small class="text-muted">{{ trans('messages.profit_margin') }}</small>
                    <h5 class="mb-0">{{ number_format($profitMargin ?? 0, 2) }}%</h5>
                </div>
                @endif
            </div>
        </div>
    </div>
    <div class="col-md-8">
        <!-- Purchase History Filter -->
        <div class="card mb-3">
            <div class="card-body">
                <form method="GET" action="{{ route('customers.show', $customer) }}">
                    <div class="row g-3">
                        <div class="col-md-4">
                            <label for="date_from" class="form-label">{{ trans('messages.from_date') }}</label>
                            <input type="date" name="date_from" class="form-control" value="{{ $dateFrom ?? '' }}">
                        </div>
                        <div class="col-md-4">
                            <label for="date_to" class="form-label">{{ trans('messages.to_date') }}</label>
                            <input type="date" name="date_to" class="form-control" value="{{ $dateTo ?? '' }}">
                        </div>
                        <div class="col-md-4">
                            <label class="form-label">&nbsp;</label>
                            <div class="d-flex gap-2">
                                <button type="submit" class="btn btn-primary w-100">{{ trans('messages.filter') }}</button>
                                <a href="{{ route('customers.show', $customer) }}" class="btn btn-secondary">{{ trans('messages.reset') }}</a>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>

        <!-- Purchase History -->
        <div class="card mb-3">
            <div class="card-header d-flex justify-content-between align-items-center">
                <h5 class="mb-0"><i class="bi bi-receipt"></i> {{ trans('messages.purchase_history') }}</h5>
                <span class="badge bg-primary">{{ $invoiceCount ?? 0 }} {{ trans('messages.invoices') }}</span>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-hover">
                        <thead>
                            <tr>
                                <th>{{ trans('messages.invoice_number') }}</th>
                                <th>{{ trans('messages.date') }}</th>
                                <th class="text-end">{{ trans('messages.total') }}</th>
                                <th class="text-end">{{ trans('messages.paid') }}</th>
                                <th class="text-end">{{ trans('messages.due') }}</th>
                                <th>{{ trans('messages.status') }}</th>
                                <th>{{ trans('messages.items') }}</th>
                                <th>{{ trans('messages.actions') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse(($invoices ?? $customer->invoices) as $invoice)
                            <tr>
                                <td><a href="{{ route('invoices.show', $invoice) }}">{{ $invoice->invoice_number }}</a></td>
                                <td>{{ $invoice->created_at->format('Y-m-d') }}</td>
                                <td class="text-end"><strong>{{ format_currency($invoice->total) }}</strong></td>
                                <td class="text-end text-success">{{ format_currency($invoice->paid_amount) }}</td>
                                <td class="text-end text-danger">{{ format_currency($invoice->due_amount) }}</td>
                                <td>
                                    @php
                                        $badgeClass = match($invoice->status) {
                                            'paid' => 'success',
                                            'partially_paid' => 'warning',
                                            'draft' => 'secondary',
                                            'returned' => 'danger',
                                            default => 'info'
                                        };
                                    @endphp
                                    <span class="badge bg-{{ $badgeClass }}">{{ trans('messages.' . $invoice->status) }}</span>
                                </td>
                                <td>
                                    <span class="badge bg-info">{{ $invoice->items->count() }} {{ trans('messages.items') }}</span>
                                </td>
                                <td>
                                    <a href="{{ route('invoices.show', $invoice) }}" class="btn btn-sm btn-info" title="{{ trans('messages.view') }}">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="8" class="text-center">{{ trans('messages.no_invoices_found') }}</td>
                            </tr>
                            @endforelse
                        </tbody>
                        @if(isset($invoices) && $invoices->count() > 0)
                        <tfoot>
                            <tr class="table-primary">
                                <th colspan="2">{{ trans('messages.total') }}</th>
                                <th class="text-end">{{ format_currency($totalPurchases ?? 0) }}</th>
                                <th class="text-end">{{ format_currency($totalPaid ?? 0) }}</th>
                                <th class="text-end">{{ format_currency($totalDue ?? 0) }}</th>
                                <th colspan="3"></th>
                            </tr>
                        </tfoot>
                        @endif
                    </table>
                </div>
            </div>
        </div>

        <!-- Top Products Purchased -->
        @if(isset($topProducts) && $topProducts->count() > 0)
        <div class="card mb-3">
            <div class="card-header">
                <h5 class="mb-0"><i class="bi bi-star"></i> {{ trans('messages.top_products_purchased') }}</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-sm">
                        <thead>
                            <tr>
                                <th>{{ trans('messages.product') }}</th>
                                <th class="text-end">{{ trans('messages.quantity') }}</th>
                                <th class="text-end">{{ trans('messages.total_amount') }}</th>
                                <th class="text-end">{{ trans('messages.invoice_count') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($topProducts as $product)
                            <tr>
                                <td>
                                    <strong>{{ $product['product']->name ?? $product['product']->name_ar ?? trans('messages.unknown') }}</strong>
                                    @if($product['product']->category)
                                        <br><small class="text-muted">{{ $product['product']->category->name }}</small>
                                    @endif
                                </td>
                                <td class="text-end">{{ number_format($product['quantity']) }}</td>
                                <td class="text-end"><strong>{{ format_currency($product['total_amount']) }}</strong></td>
                                <td class="text-end">{{ $product['invoice_count'] }}</td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        @endif

        <!-- Monthly Purchases Breakdown -->
        @if(isset($monthlyPurchases) && $monthlyPurchases->count() > 0)
        <div class="card mb-3">
            <div class="card-header">
                <h5 class="mb-0"><i class="bi bi-calendar-month"></i> {{ trans('messages.monthly_purchases') }}</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-sm">
                        <thead>
                            <tr>
                                <th>{{ trans('messages.month') }}</th>
                                <th class="text-end">{{ trans('messages.invoice_count') }}</th>
                                <th class="text-end">{{ trans('messages.total_amount') }}</th>
                                <th class="text-end">{{ trans('messages.profit') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($monthlyPurchases as $month)
                            <tr>
                                <td><strong>{{ $month['month'] }}</strong></td>
                                <td class="text-end">{{ $month['count'] }}</td>
                                <td class="text-end">{{ format_currency($month['total']) }}</td>
                                <td class="text-end {{ $month['profit'] >= 0 ? 'text-success' : 'text-danger' }}">
                                    {{ format_currency($month['profit']) }}
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        @endif

        <!-- Payment Methods Breakdown -->
        @if(isset($paymentMethodsBreakdown) && $paymentMethodsBreakdown->count() > 0)
        <div class="card mb-3">
            <div class="card-header">
                <h5 class="mb-0"><i class="bi bi-credit-card"></i> {{ trans('messages.payment_methods_breakdown') }}</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-sm">
                        <thead>
                            <tr>
                                <th>{{ trans('messages.payment_method') }}</th>
                                <th class="text-end">{{ trans('messages.count') }}</th>
                                <th class="text-end">{{ trans('messages.total_amount') }}</th>
                                <th class="text-end">{{ trans('messages.percentage') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach($paymentMethodsBreakdown as $method)
                            <tr>
                                <td><strong>{{ trans('messages.' . $method['method']) }}</strong></td>
                                <td class="text-end">{{ $method['count'] }}</td>
                                <td class="text-end">{{ format_currency($method['total']) }}</td>
                                <td class="text-end">
                                    {{ $totalPaid > 0 ? number_format(($method['total'] / $totalPaid) * 100, 2) : 0 }}%
                                </td>
                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
        @endif

        <!-- Cheques Section -->
        <div class="card mt-3">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.cheques') }}</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>{{ trans('messages.cheque_number') }}</th>
                                <th>{{ trans('messages.bank_name') }}</th>
                                <th>{{ trans('messages.amount') }}</th>
                                <th>{{ trans('messages.issue_date') }}</th>
                                <th>{{ trans('messages.due_date') }}</th>
                                <th>{{ trans('messages.status') }}</th>
                                <th>{{ trans('messages.actions') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($customer->cheques as $cheque)
                            <tr>
                                <td>{{ $cheque->cheque_number }}</td>
                                <td>{{ $cheque->bank_name }}</td>
                                <td>{{ format_currency($cheque->amount) }}</td>
                                <td>{{ $cheque->issue_date->format('Y-m-d') }}</td>
                                <td>{{ $cheque->due_date->format('Y-m-d') }}</td>
                                <td>
                                    @php
                                        $badgeClass = match($cheque->status) {
                                            'paid' => 'success',
                                            'returned' => 'danger',
                                            'cancelled' => 'secondary',
                                            'due' => 'warning',
                                            default => 'info'
                                        };
                                    @endphp
                                    <span class="badge bg-{{ $badgeClass }}">{{ trans('messages.' . $cheque->status) }}</span>
                                </td>
                                <td>
                                    <a href="{{ route('cheques.show', $cheque) }}" class="btn btn-sm btn-info">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="7" class="text-center">{{ trans('messages.no_cheques_found') }}</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Promissory Notes Section -->
        <div class="card mt-3">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.promissory_notes') }}</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table">
                        <thead>
                            <tr>
                                <th>{{ trans('messages.note_number') }}</th>
                                <th>{{ trans('messages.amount') }}</th>
                                <th>{{ trans('messages.issue_date') }}</th>
                                <th>{{ trans('messages.due_date') }}</th>
                                <th>{{ trans('messages.status') }}</th>
                                <th>{{ trans('messages.actions') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($customer->promissoryNotes as $promissoryNote)
                            <tr>
                                <td>{{ $promissoryNote->note_number }}</td>
                                <td>{{ format_currency($promissoryNote->amount) }}</td>
                                <td>{{ $promissoryNote->issue_date->format('Y-m-d') }}</td>
                                <td>{{ $promissoryNote->due_date->format('Y-m-d') }}</td>
                                <td>
                                    @php
                                        $badgeClass = match($promissoryNote->status) {
                                            'paid' => 'success',
                                            'cancelled' => 'secondary',
                                            'due' => 'warning',
                                            default => 'info'
                                        };
                                    @endphp
                                    <span class="badge bg-{{ $badgeClass }}">{{ trans('messages.' . $promissoryNote->status) }}</span>
                                </td>
                                <td>
                                    <a href="{{ route('promissory-notes.show', $promissoryNote) }}" class="btn btn-sm btn-info">
                                        <i class="bi bi-eye"></i>
                                    </a>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="6" class="text-center">{{ trans('messages.no_promissory_notes_found') }}</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- Documents Section -->
        @include('documents.partials.manage', ['type' => 'customer', 'id' => $customer->id])
    </div>
</div>
@endsection
