<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}" dir="{{ app()->getLocale() === 'ar' ? 'rtl' : 'ltr' }}">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ trans('messages.invoice_reminder') }}</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
        }
        .header {
            text-align: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 20px;
        }
        .reminder-box {
            background: #fff3cd;
            border: 2px solid #ffc107;
            padding: 20px;
            border-radius: 5px;
            margin: 20px 0;
        }
        .invoice-info {
            background: #f9f9f9;
            padding: 15px;
            border-radius: 5px;
            margin: 20px 0;
        }
        .amount-due {
            font-size: 24px;
            font-weight: bold;
            color: #dc3545;
            text-align: center;
            margin: 20px 0;
        }
        .footer {
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #ddd;
            text-align: center;
            color: #666;
            font-size: 12px;
        }
    </style>
</head>
<body>
    <div class="header">
        <h1>{{ \App\Models\Setting::get('store_name', 'Gestock Pro') }}</h1>
        <h2>{{ trans('messages.invoice_reminder') }}</h2>
    </div>

    <div class="reminder-box">
        <h3>{{ trans('messages.dear_customer') }}</h3>
        <p>{{ trans('messages.invoice_reminder_message', [
            'invoice_number' => $invoice->invoice_number,
            'amount' => format_currency($invoice->due_amount),
            'days' => $daysOverdue
        ]) }}</p>
    </div>

    <div class="invoice-info">
        <p><strong>{{ trans('messages.invoice_number') }}:</strong> {{ $invoice->invoice_number }}</p>
        <p><strong>{{ trans('messages.date') }}:</strong> {{ $invoice->created_at->format('Y-m-d') }}</p>
        <p><strong>{{ trans('messages.total') }}:</strong> {{ format_currency($invoice->total) }}</p>
        <p><strong>{{ trans('messages.paid') }}:</strong> {{ format_currency($invoice->paid_amount) }}</p>
    </div>

    <div class="amount-due">
        {{ trans('messages.amount_due') }}: {{ format_currency($invoice->due_amount) }}
    </div>

    <div class="footer">
        <p>{{ trans('messages.please_contact_us') }}</p>
        <p>{{ \App\Models\Setting::get('invoice_footer_text', '') }}</p>
        <p>{{ trans('messages.thank_you') }}</p>
    </div>
</body>
</html>

