@extends('layouts.master')

@section('title', trans('messages.inventory_details'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.inventory') }}: {{ $inventory->reference }}</h2>
    <div>
        @if($inventory->isDraft())
            <form action="{{ route('inventories.complete', $inventory) }}" method="POST" class="d-inline">
                @csrf
                <button type="submit" class="btn btn-success" onclick="return confirm('{{ trans('messages.confirm_complete_inventory') }}');">
                    <i class="bi bi-check-circle"></i> {{ trans('messages.complete_inventory') }}
                </button>
            </form>
            <form action="{{ route('inventories.destroy', $inventory) }}" method="POST" class="d-inline delete-form">
                @csrf
                @method('DELETE')
                <button type="submit" class="btn btn-danger" onclick="event.preventDefault(); confirmAction('{{ trans('messages.confirm_delete_inventory') }}', '{{ trans('messages.confirm_delete') }}', () => this.closest('form').submit()); return false;" title="{{ trans('messages.delete') }}">
                    <i class="bi bi-trash"></i> {{ trans('messages.delete') }}
                </button>
            </form>
        @endif
        <a href="{{ route('inventories.print', $inventory) }}" class="btn btn-warning" target="_blank">
            <i class="bi bi-printer"></i> {{ trans('messages.print') }}
        </a>
        <a href="{{ route('inventories.index') }}" class="btn btn-secondary">
            <i class="bi bi-arrow-left"></i> {{ trans('messages.back') }}
        </a>
    </div>
</div>

<div class="card mb-3">
    <div class="card-body">
        <div class="row">
            <div class="col-md-6">
                <p><strong>{{ trans('messages.reference') }}:</strong> {{ $inventory->reference }}</p>
                <p><strong>{{ trans('messages.date') }}:</strong> {{ $inventory->inventory_date ? \Carbon\Carbon::parse($inventory->inventory_date)->format('Y-m-d') : '-' }}</p>
                <p><strong>{{ trans('messages.status') }}:</strong> 
                    <span class="badge bg-{{ $inventory->status == 'completed' ? 'success' : ($inventory->status == 'cancelled' ? 'danger' : 'warning') }}">
                        {{ trans('messages.' . $inventory->status) }}
                    </span>
                </p>
            </div>
            <div class="col-md-6">
                <p><strong>{{ trans('messages.created_by') }}:</strong> {{ $inventory->user->name }}</p>
                <p><strong>{{ trans('messages.created_at') }}:</strong> {{ $inventory->created_at->format('Y-m-d H:i') }}</p>
            </div>
        </div>
        @if($inventory->notes)
        <p><strong>{{ trans('messages.notes') }}:</strong> {{ $inventory->notes }}</p>
        @endif
    </div>
</div>

<div class="card">
    <div class="card-body">
        <h5 class="card-title">{{ trans('messages.inventory_items') }}</h5>
        <div class="table-responsive">
            <table class="table table-striped">
                <thead>
                    <tr>
                        <th>{{ trans('messages.product') }}</th>
                        <th>{{ trans('messages.category') }}</th>
                        <th>{{ trans('messages.system_quantity') }}</th>
                        <th>{{ trans('messages.physical_quantity') }}</th>
                        <th>{{ trans('messages.difference') }}</th>
                        <th>{{ trans('messages.notes') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($inventory->items as $item)
                    <tr>
                        <td>{{ $item->product->name }}</td>
                        <td>{{ $item->product->category?->name ?? 'N/A' }}</td>
                        <td>{{ $item->system_quantity }}</td>
                        <td>{{ $item->physical_quantity }}</td>
                        <td>
                            <span class="badge bg-{{ $item->difference > 0 ? 'success' : ($item->difference < 0 ? 'danger' : 'secondary') }}">
                                {{ $item->difference > 0 ? '+' : '' }}{{ $item->difference }}
                            </span>
                        </td>
                        <td>{{ $item->notes ?? '-' }}</td>
                    </tr>
                    @endforeach
                </tbody>
            </table>
        </div>
    </div>
</div>
@endsection

