@php
    $storeName = \App\Models\Setting::get('store_name', 'Gestock Pro');
    $storeLogo = \App\Models\Setting::get('store_logo');
    $currency = currency_symbol();
    $footerText = \App\Models\Setting::get('invoice_footer_text', '');
    $locale = app()->getLocale();
    $isRTL = $locale === 'ar';
    $dir = $isRTL ? 'rtl' : 'ltr';
    $showLogo = \App\Models\Setting::get('invoice_show_logo', '1') === '1';
@endphp
<!DOCTYPE html>
<html lang="{{ $locale }}" dir="{{ $dir }}">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ trans('messages.delivery_note') }} {{ $invoice->invoice_number }}</title>
    <link rel="stylesheet" href="{{ asset('lib/fonts/google-fonts.css') }}">
    <link href="{{ asset('lib/css/bootstrap.min.css') }}" rel="stylesheet">
    <style>
        @charset "UTF-8";
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        @media print {
            .no-print {
                display: none !important;
            }
            body {
                padding: 0;
            }
        }
        
        body {
            font-family: {{ $isRTL ? "'Cairo', 'DejaVu Sans', sans-serif" : "'Cabin', 'DejaVu Sans', sans-serif" }};
            direction: {{ $dir }};
            padding: 20px;
            unicode-bidi: embed;
            font-size: 14px;
            color: #333;
        }
        
        @if($isRTL)
        * {
            font-family: 'Cairo', 'DejaVu Sans', sans-serif !important;
        }
        @else
        * {
            font-family: 'Cabin', 'DejaVu Sans', sans-serif !important;
        }
        @endif
        .header {
            border-bottom: 3px solid #17a2b8;
            padding-bottom: 20px;
            margin-bottom: 30px;
        }
        .document-title h1 {
            color: #17a2b8;
            font-weight: bold;
        }
        .sender-info, .receiver-info {
            border: 1px solid #ddd;
            padding: 15px;
            border-radius: 5px;
        }
        .sender-info h3, .receiver-info h3 {
            color: #17a2b8;
            border-bottom: 1px solid #ddd;
            padding-bottom: 5px;
        }
        table th {
            background-color: #17a2b8;
            color: white;
        }
        .total-table .total-row td {
            background-color: #17a2b8;
            color: white;
            font-weight: bold;
        }
        .signature-section {
            margin-top: 50px;
        }
        .signature-box {
            border-top: 2px solid #333;
            padding-top: 10px;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="text-center mb-3 no-print">
            <button onclick="window.print()" class="btn btn-primary">
                <i class="bi bi-printer"></i> {{ $isRTL ? 'طباعة' : 'Imprimer' }}
            </button>
            <button onclick="window.close()" class="btn btn-secondary ms-2">
                <i class="bi bi-x-circle"></i> {{ trans('messages.close') }}
            </button>
        </div>
        
        <div class="header">
            <div class="row align-items-center">
                <div class="col-md-6">
                    @if($showLogo && $storeLogo)
                        <img src="{{ storage_url( $storeLogo) }}" alt="{{ $storeName }}" style="max-height: 80px;">
                    @else
                        <h3>{{ $storeName }}</h3>
                    @endif
                </div>
                <div class="col-md-6 text-{{ $isRTL ? 'start' : 'end' }}">
                    <h1 class="document-title">{{ strtoupper(trans('messages.delivery_note')) }}</h1>
                    <p><strong>N°:</strong> {{ $invoice->invoice_number }}</p>
                </div>
            </div>
        </div>

        <div class="row mb-4">
            <div class="col-md-6">
                <div class="sender-info">
                    <h3>{{ $isRTL ? 'المرسل' : 'Expéditeur' }} / {{ trans('messages.store') }}</h3>
                    <p><strong>{{ trans('messages.name') }}:</strong> {{ $storeName }}</p>
                    @php
                        $storeAddress = \App\Models\Setting::get('store_address');
                        $storePhone = \App\Models\Setting::get('store_phone');
                        $storeEmail = \App\Models\Setting::get('store_email');
                    @endphp
                    @if($storeAddress)
                        <p><strong>{{ trans('messages.address') }}:</strong> {{ $storeAddress }}</p>
                    @endif
                    @if($storePhone)
                        <p><strong>{{ trans('messages.phone') }}:</strong> {{ $storePhone }}</p>
                    @endif
                    @if($storeEmail)
                        <p><strong>{{ trans('messages.email') }}:</strong> {{ $storeEmail }}</p>
                    @endif
                </div>
            </div>
            <div class="col-md-6">
                <div class="receiver-info">
                    <h3>{{ $isRTL ? 'المستلم' : 'Destinataire' }} / {{ trans('messages.customer') }}</h3>
                    <p><strong>{{ trans('messages.name') }}:</strong> {{ $invoice->customer?->name ?? $invoice->customer_name }}</p>
                    @if($invoice->customer)
                        @if($invoice->customer->email)
                            <p><strong>{{ trans('messages.email') }}:</strong> {{ $invoice->customer->email }}</p>
                        @endif
                        @if($invoice->customer->phone)
                            <p><strong>{{ trans('messages.phone') }}:</strong> {{ $invoice->customer->phone }}</p>
                        @endif
                        @if($invoice->customer->address)
                            <p><strong>{{ trans('messages.address') }}:</strong> {{ $invoice->customer->address }}</p>
                        @endif
                    @endif
                </div>
            </div>
        </div>

        <div class="card mb-4">
            <div class="card-body bg-light">
                <div class="row">
                    <div class="col-md-4">
                        <strong>{{ trans('messages.date') }}:</strong> {{ $invoice->created_at->format('d/m/Y') }}
                    </div>
                    <div class="col-md-4">
                        <strong>{{ trans('messages.created_by') }}:</strong> {{ $invoice->user->name }}
                    </div>
                    <div class="col-md-4">
                        <strong>{{ $isRTL ? 'رقم الفاتورة المرجعية' : 'Référence Facture' }}:</strong> {{ $invoice->invoice_number }}
                    </div>
                    @if($invoice->status === 'draft')
                    <div class="col-md-4 mt-2">
                        <strong>{{ $isRTL ? 'الحالة' : 'Statut' }}:</strong> 
                        <span class="badge bg-warning">{{ $isRTL ? 'مسودة' : 'Brouillon' }}</span>
                    </div>
                    @endif
                </div>
            </div>
        </div>

        <table class="table table-bordered">
            <thead>
                <tr>
                    <th style="width: 5%;">#</th>
                    <th style="width: 35%;">{{ trans('messages.products') }}</th>
                    <th style="width: 15%;">{{ trans('messages.quantity') }}</th>
                    <th style="width: 15%;">{{ trans('messages.unit_price') }}</th>
                    <th style="width: 15%;">{{ trans('messages.tax') }}</th>
                    <th style="width: 15%;">{{ trans('messages.total') }}</th>
                </tr>
            </thead>
            <tbody>
                @foreach($invoice->items as $index => $item)
                <tr>
                    <td>{{ $index + 1 }}</td>
                    <td>
                        <strong>{{ $item->product->name }}</strong>
                        @if($item->product->sku)
                            <br><small class="text-muted">SKU: {{ $item->product->sku }}</small>
                        @endif
                    </td>
                    <td>{{ $item->quantity }} {{ $item->product->unit ?? '' }}</td>
                    <td>{{ number_format($item->unit_price, 2) }} {{ $currency }}</td>
                    <td>{{ $item->tax_rate }}%</td>
                    <td><strong>{{ number_format($item->total, 2) }} {{ $currency }}</strong></td>
                </tr>
                @endforeach
            </tbody>
        </table>

        <div class="row">
            <div class="col-md-6"></div>
            <div class="col-md-6">
                <table class="table table-bordered total-table">
                    <tr>
                        <td><strong>{{ trans('messages.subtotal') }}</strong></td>
                        <td class="text-{{ $isRTL ? 'start' : 'end' }}">{{ number_format($invoice->subtotal, 2) }} {{ $currency }}</td>
                    </tr>
                    @if($invoice->discount > 0)
                    <tr>
                        <td><strong>{{ trans('messages.discount') }}</strong></td>
                        <td class="text-{{ $isRTL ? 'start' : 'end' }}">-{{ number_format($invoice->discount, 2) }} {{ $currency }}</td>
                    </tr>
                    @endif
                    <tr>
                        <td><strong>{{ trans('messages.tax') }}</strong></td>
                        <td class="text-{{ $isRTL ? 'start' : 'end' }}">{{ number_format($invoice->tax, 2) }} {{ $currency }}</td>
                    </tr>
                    <tr class="total-row">
                        <td><strong>{{ $isRTL ? 'المجموع الكلي' : 'Total TTC' }}</strong></td>
                        <td class="text-{{ $isRTL ? 'start' : 'end' }}"><strong>{{ number_format($invoice->total, 2) }} {{ $currency }}</strong></td>
                    </tr>
                </table>
            </div>
        </div>

        @if($invoice->notes)
        <div class="card mt-4">
            <div class="card-body" style="border-left: 4px solid #17a2b8;">
                <h5 class="card-title" style="color: #17a2b8;">{{ $isRTL ? 'ملاحظات' : 'Notes' }} / {{ trans('messages.notes') }}:</h5>
                <p class="card-text">{{ $invoice->notes }}</p>
            </div>
        </div>
        @endif

        <div class="row signature-section">
            <div class="col-md-6">
                <div class="signature-box">
                    <p><strong>{{ $isRTL ? 'توقيع المرسل' : 'Signature Expéditeur' }}</strong></p>
                    <p style="margin-top: 40px;">_________________________</p>
                    <p style="margin-top: 5px;">{{ $invoice->user->name }}</p>
                    <p style="margin-top: 5px;">{{ $invoice->created_at->format('d/m/Y') }}</p>
                </div>
            </div>
            <div class="col-md-6">
                <div class="signature-box">
                    <p><strong>{{ $isRTL ? 'توقيع المستلم' : 'Signature Destinataire' }}</strong></p>
                    <p style="margin-top: 40px;">_________________________</p>
                    <p style="margin-top: 5px;">{{ $invoice->customer?->name ?? $invoice->customer_name }}</p>
                    <p style="margin-top: 5px;">{{ $isRTL ? 'التاريخ' : 'Date' }}: _______________</p>
                </div>
            </div>
        </div>

        @if($footerText)
        <div class="mt-4 pt-3 border-top">
            <p class="text-muted small">{{ $footerText }}</p>
        </div>
        @endif
    </div>
</body>
</html>

