@php
    $storeName = \App\Models\Setting::get('store_name', 'Gestock Pro');
    $storeLogo = \App\Models\Setting::get('store_logo');
    $currency = currency_symbol();
    $footerText = \App\Models\Setting::get('invoice_footer_text', '');
    $locale = app()->getLocale();
    $isRTL = $locale === 'ar';
    $dir = $isRTL ? 'rtl' : 'ltr';
    $showLogo = \App\Models\Setting::get('invoice_show_logo', '1') === '1';
@endphp
<!DOCTYPE html>
<html lang="{{ $locale }}" dir="{{ $dir }}">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <title>{{ trans('messages.delivery_note') }} {{ $invoice->invoice_number }}</title>
    <style>
        @charset "UTF-8";
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: {{ $isRTL ? "'Cairo', DejaVu Sans, sans-serif" : "DejaVu Sans, 'Cabin', sans-serif" }};
            direction: {{ $dir }};
            font-size: 12px;
            color: #333;
            padding: 20px;
            unicode-bidi: embed;
        }
        
        @if($isRTL)
        * {
            font-family: 'Cairo', DejaVu Sans, sans-serif !important;
        }
        @else
        * {
            font-family: DejaVu Sans, 'Cabin', sans-serif !important;
        }
        @endif
        
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
            border-bottom: 3px solid #17a2b8;
            padding-bottom: 20px;
        }
        
        .logo-container {
            {{ $isRTL ? 'text-align: right;' : 'text-align: left;' }}
        }
        
        .logo-container img {
            max-height: 80px;
            max-width: 200px;
        }
        
        .document-title {
            {{ $isRTL ? 'text-align: left;' : 'text-align: right;' }}
        }
        
        .document-title h1 {
            color: #17a2b8;
            font-size: 24px;
            margin-bottom: 5px;
            font-weight: bold;
        }
        
        .document-title .document-number {
            font-size: 14px;
            color: #666;
        }
        
        .document-details {
            display: flex;
            justify-content: space-between;
            margin-bottom: 30px;
            gap: 20px;
        }
        
        .sender-info, .receiver-info {
            width: 48%;
            border: 1px solid #ddd;
            padding: 15px;
            border-radius: 5px;
        }
        
        .sender-info h3, .receiver-info h3 {
            margin-bottom: 10px;
            font-size: 14px;
            color: #17a2b8;
            border-bottom: 1px solid #ddd;
            padding-bottom: 5px;
        }
        
        .sender-info p, .receiver-info p {
            margin: 5px 0;
            font-size: 11px;
        }
        
        .delivery-info {
            background-color: #f8f9fa;
            padding: 15px;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        
        .delivery-info-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 8px;
        }
        
        .delivery-info-row strong {
            color: #333;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        
        th, td {
            border: 1px solid #ddd;
            padding: 10px;
            text-align: {{ $isRTL ? 'right' : 'left' }};
        }
        
        th {
            background-color: #17a2b8;
            color: white;
            font-weight: bold;
        }
        
        tbody tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        
        .total-table {
            width: 100%;
            max-width: 400px;
            margin-top: 20px;
            {{ $isRTL ? 'margin-right: auto;' : 'margin-left: auto;' }}
            border-collapse: collapse;
        }
        
        .total-table td {
            padding: 8px 15px;
            border: 1px solid #ddd;
            {{ $isRTL ? 'text-align: right;' : 'text-align: left;' }}
        }
        
        .total-table td:first-child {
            font-weight: bold;
            background-color: #f9f9f9;
            {{ $isRTL ? 'text-align: right;' : 'text-align: left;' }}
        }
        
        .total-table td:last-child {
            {{ $isRTL ? 'text-align: left;' : 'text-align: right;' }}
            font-weight: normal;
        }
        
        .total-table .total-row td {
            background-color: #17a2b8;
            color: white;
            font-weight: bold;
            font-size: 14px;
            border-top: 2px solid #333;
        }
        
        .total-table .total-row td:last-child {
            {{ $isRTL ? 'text-align: left;' : 'text-align: right;' }}
        }
        
        .signature-section {
            margin-top: 50px;
            display: flex;
            justify-content: space-between;
        }
        
        .signature-box {
            width: 45%;
            border-top: 2px solid #333;
            padding-top: 10px;
            {{ $isRTL ? 'text-align: right;' : 'text-align: left;' }}
        }
        
        .signature-box p {
            margin: 5px 0;
            font-size: 11px;
        }
        
        .notes-section {
            margin-top: 30px;
            padding: 15px;
            background-color: #f8f9fa;
            border-radius: 5px;
            border-left: 4px solid #17a2b8;
        }
        
        .notes-section h4 {
            margin-bottom: 10px;
            color: #17a2b8;
        }
        
        .footer {
            margin-top: 40px;
            padding-top: 20px;
            border-top: 1px solid #ddd;
            {{ $isRTL ? 'text-align: right;' : 'text-align: left;' }}
            font-size: 10px;
            color: #666;
        }
    </style>
</head>
<body>
    <div class="header">
        <div class="logo-container">
            @if($showLogo && $storeLogo)
                <img src="{{ \Storage::disk('public')->path($storeLogo) }}" alt="{{ $storeName }}">
            @else
                <h2>{{ $storeName }}</h2>
            @endif
        </div>
        <div class="document-title">
            <h1>{{ strtoupper(trans('messages.delivery_note')) }}</h1>
            <div class="document-number">
                <strong>N°:</strong> {{ $invoice->invoice_number }}
            </div>
        </div>
    </div>

    <div class="document-details">
        <div class="sender-info">
            <h3>{{ $isRTL ? 'المرسل' : 'Expéditeur' }} / {{ trans('messages.store') }}</h3>
            <p><strong>{{ trans('messages.name') }}:</strong> {{ $storeName }}</p>
            @php
                $storeAddress = \App\Models\Setting::get('store_address');
                $storePhone = \App\Models\Setting::get('store_phone');
                $storeEmail = \App\Models\Setting::get('store_email');
            @endphp
            @if($storeAddress)
                <p><strong>{{ trans('messages.address') }}:</strong> {{ $storeAddress }}</p>
            @endif
            @if($storePhone)
                <p><strong>{{ trans('messages.phone') }}:</strong> {{ $storePhone }}</p>
            @endif
            @if($storeEmail)
                <p><strong>{{ trans('messages.email') }}:</strong> {{ $storeEmail }}</p>
            @endif
        </div>
        <div class="receiver-info">
            <h3>{{ $isRTL ? 'المستلم' : 'Destinataire' }} / {{ trans('messages.customer') }}</h3>
            <p><strong>{{ trans('messages.name') }}:</strong> {{ $invoice->customer?->name ?? $invoice->customer_name }}</p>
            @if($invoice->customer)
                @if($invoice->customer->email)
                    <p><strong>{{ trans('messages.email') }}:</strong> {{ $invoice->customer->email }}</p>
                @endif
                @if($invoice->customer->phone)
                    <p><strong>{{ trans('messages.phone') }}:</strong> {{ $invoice->customer->phone }}</p>
                @endif
                @if($invoice->customer->address)
                    <p><strong>{{ trans('messages.address') }}:</strong> {{ $invoice->customer->address }}</p>
                @endif
            @endif
        </div>
    </div>

    <div class="delivery-info">
        <div class="delivery-info-row">
            <strong>{{ trans('messages.date') }}:</strong>
            <span>{{ $invoice->created_at->format('d/m/Y') }}</span>
        </div>
        <div class="delivery-info-row">
            <strong>{{ trans('messages.created_by') }}:</strong>
            <span>{{ $invoice->user->name }}</span>
        </div>
        <div class="delivery-info-row">
            <strong>{{ $isRTL ? 'رقم الفاتورة المرجعية' : 'Référence Facture' }}:</strong>
            <span>{{ $invoice->invoice_number }}</span>
        </div>
        @if($invoice->status === 'draft')
        <div class="delivery-info-row">
            <strong>{{ $isRTL ? 'الحالة' : 'Statut' }}:</strong>
            <span style="color: #ffc107; font-weight: bold;">{{ $isRTL ? 'مسودة' : 'Brouillon' }}</span>
        </div>
        @endif
    </div>

    <table>
        <thead>
            <tr>
                <th style="width: 5%;">#</th>
                <th style="width: 35%;">{{ trans('messages.products') }}</th>
                <th style="width: 15%;">{{ trans('messages.quantity') }}</th>
                <th style="width: 15%;">{{ trans('messages.unit_price') }}</th>
                <th style="width: 15%;">{{ trans('messages.tax') }}</th>
                <th style="width: 15%;">{{ trans('messages.total') }}</th>
            </tr>
        </thead>
        <tbody>
            @foreach($invoice->items as $index => $item)
            <tr>
                <td>{{ $index + 1 }}</td>
                <td>
                    <strong>{{ $item->product->name }}</strong>
                    @if($item->product->sku)
                        <br><small style="color: #666;">SKU: {{ $item->product->sku }}</small>
                    @endif
                </td>
                <td>{{ $item->quantity }} {{ $item->product->unit ?? '' }}</td>
                <td>{{ number_format($item->unit_price, 2) }} {{ $currency }}</td>
                <td>{{ $item->tax_rate }}%</td>
                <td><strong>{{ number_format($item->total, 2) }} {{ $currency }}</strong></td>
            </tr>
            @endforeach
        </tbody>
    </table>

    <table class="total-table">
        <tr>
            <td>{{ trans('messages.subtotal') }}</td>
            <td>{{ number_format($invoice->subtotal, 2) }} {{ $currency }}</td>
        </tr>
        @if($invoice->discount > 0)
        <tr>
            <td>{{ trans('messages.discount') }}</td>
            <td>-{{ number_format($invoice->discount, 2) }} {{ $currency }}</td>
        </tr>
        @endif
        <tr>
            <td>{{ trans('messages.tax') }}</td>
            <td>{{ number_format($invoice->tax, 2) }} {{ $currency }}</td>
        </tr>
        <tr class="total-row">
            <td>{{ $isRTL ? 'المجموع الكلي' : 'Total TTC' }}</td>
            <td>{{ number_format($invoice->total, 2) }} {{ $currency }}</td>
        </tr>
    </table>

    @if($invoice->notes)
    <div class="notes-section">
        <h4>{{ $isRTL ? 'ملاحظات' : 'Notes' }} / {{ trans('messages.notes') }}:</h4>
        <p>{{ $invoice->notes }}</p>
    </div>
    @endif

    <div class="signature-section">
        <div class="signature-box">
            <p><strong>{{ $isRTL ? 'توقيع المرسل' : 'Signature Expéditeur' }}</strong></p>
            <p style="margin-top: 40px;">_________________________</p>
            <p style="margin-top: 5px;">{{ $invoice->user->name }}</p>
            <p style="margin-top: 5px;">{{ $invoice->created_at->format('d/m/Y') }}</p>
        </div>
        <div class="signature-box">
            <p><strong>{{ $isRTL ? 'توقيع المستلم' : 'Signature Destinataire' }}</strong></p>
            <p style="margin-top: 40px;">_________________________</p>
            <p style="margin-top: 5px;">{{ $invoice->customer?->name ?? $invoice->customer_name }}</p>
            <p style="margin-top: 5px;">{{ $isRTL ? 'التاريخ' : 'Date' }}: _______________</p>
        </div>
    </div>

    @if($footerText)
    <div class="footer">
        <p>{{ $footerText }}</p>
    </div>
    @endif
</body>
</html>

