@extends('layouts.master')

@section('title', trans('messages.invoices'))

@section('content')
@php
    $sort = request()->get('sort', 'created_at');
    $direction = request()->get('direction', 'desc');
@endphp
<div class="page-header">
    <h2>{{ trans('messages.invoices') }}</h2>
    <div class="d-flex gap-2">
        @can('invoices.create')
            <a href="{{ route('invoices.create') }}" class="btn btn-primary">
                <i class="bi bi-receipt"></i> {{ trans('messages.create_invoice') }}
            </a>
        @endcan
        @can('invoices.export')
            <a href="{{ route('invoices.export', request()->query()) }}" class="btn btn-success"><i class="bi bi-file-earmark-excel"></i> {{ trans('messages.export_excel') }}</a>
        @endcan
        @can('invoices.import')
            <a href="{{ route('invoices.import') }}" class="btn btn-info"><i class="bi bi-upload"></i> {{ trans('messages.import_invoices') }}</a>
        @endcan
    </div>
</div>

<div class="card">
    <div class="card-body">
        <form method="GET" action="{{ route('invoices.index') }}" class="mb-3">
            <div class="row g-3">
                <div class="col-md-3">
                    <input type="text" name="search" class="form-control" placeholder="{{ trans('messages.search') }}..." value="{{ request('search') }}">
                </div>
                <div class="col-md-2">
                    <select name="status" class="form-select">
                        <option value="">{{ trans('messages.all_status') }}</option>
                        <option value="draft" {{ request('status') == 'draft' ? 'selected' : '' }}>{{ trans('messages.draft') }}</option>
                        <option value="final" {{ request('status') == 'final' ? 'selected' : '' }}>{{ trans('messages.final') }}</option>
                        <option value="paid" {{ request('status') == 'paid' ? 'selected' : '' }}>{{ trans('messages.paid') }}</option>
                        <option value="partially_paid" {{ request('status') == 'partially_paid' ? 'selected' : '' }}>{{ trans('messages.partially_paid') }}</option>
                        <option value="returned" {{ request('status') == 'returned' ? 'selected' : '' }}>{{ trans('messages.returned') }}</option>
                    </select>
                </div>
                <div class="col-md-2">
                    <input type="date" name="date_from" class="form-control" value="{{ request('date_from') }}" placeholder="{{ trans('messages.from_date') }}">
                </div>
                <div class="col-md-2">
                    <input type="date" name="date_to" class="form-control" value="{{ request('date_to') }}" placeholder="{{ trans('messages.to_date') }}">
                </div>
                <div class="col-md-3">
                    <button type="submit" class="btn btn-secondary w-100">{{ trans('messages.filter') }}</button>
                </div>
            </div>
        </form>

        @can('invoices.bulk_delete')
        <div class="mb-3">
            <button type="button" id="delete-selected-btn" class="btn btn-danger" disabled data-bs-toggle="modal" data-bs-target="#bulkDeleteModal">
                <i class="bi bi-trash"></i> {{ trans('messages.delete_selected') }}
            </button>
        </div>
        @endcan

        <form id="bulk-delete-form" method="POST" action="{{ route('invoices.bulk_delete') }}">
            @csrf
            <div class="table-responsive">
                <table class="table table-hover">
                    <thead>
                        <tr>
                            @can('invoices.bulk_delete')
                            <th style="width: 40px;">
                                <input type="checkbox" id="select-all" title="{{ trans('messages.select_all') }}">
                            </th>
                            @endcan
                            <th>
                            <a href="{{ request()->fullUrlWithQuery(['sort' => 'invoice_number', 'direction' => ($sort === 'invoice_number' && $direction === 'asc') ? 'desc' : 'asc']) }}" class="text-decoration-none text-dark">
                                {{ trans('messages.invoice_number') }}
                                @if($sort === 'invoice_number')
                                    <i class="bi bi-arrow-{{ $direction === 'asc' ? 'up' : 'down' }}"></i>
                                @else
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                @endif
                            </a>
                        </th>
                        <th>{{ trans('messages.customer') }}</th>
                        <th>
                            <a href="{{ request()->fullUrlWithQuery(['sort' => 'created_at', 'direction' => ($sort === 'created_at' && $direction === 'asc') ? 'desc' : 'asc']) }}" class="text-decoration-none text-dark">
                                {{ trans('messages.date') }}
                                @if($sort === 'created_at')
                                    <i class="bi bi-arrow-{{ $direction === 'asc' ? 'up' : 'down' }}"></i>
                                @else
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                @endif
                            </a>
                        </th>
                        <th>
                            <a href="{{ request()->fullUrlWithQuery(['sort' => 'total', 'direction' => ($sort === 'total' && $direction === 'asc') ? 'desc' : 'asc']) }}" class="text-decoration-none text-dark">
                                {{ trans('messages.total') }}
                                @if($sort === 'total')
                                    <i class="bi bi-arrow-{{ $direction === 'asc' ? 'up' : 'down' }}"></i>
                                @else
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                @endif
                            </a>
                        </th>
                        <th>
                            <a href="{{ request()->fullUrlWithQuery(['sort' => 'paid_amount', 'direction' => ($sort === 'paid_amount' && $direction === 'asc') ? 'desc' : 'asc']) }}" class="text-decoration-none text-dark">
                                {{ trans('messages.paid') }}
                                @if($sort === 'paid_amount')
                                    <i class="bi bi-arrow-{{ $direction === 'asc' ? 'up' : 'down' }}"></i>
                                @else
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                @endif
                            </a>
                        </th>
                        <th>
                            <a href="{{ request()->fullUrlWithQuery(['sort' => 'due_amount', 'direction' => ($sort === 'due_amount' && $direction === 'asc') ? 'desc' : 'asc']) }}" class="text-decoration-none text-dark">
                                {{ trans('messages.due') }}
                                @if($sort === 'due_amount')
                                    <i class="bi bi-arrow-{{ $direction === 'asc' ? 'up' : 'down' }}"></i>
                                @else
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                @endif
                            </a>
                        </th>
                        <th>
                            <a href="{{ request()->fullUrlWithQuery(['sort' => 'status', 'direction' => ($sort === 'status' && $direction === 'asc') ? 'desc' : 'asc']) }}" class="text-decoration-none text-dark">
                                {{ trans('messages.status') }}
                                @if($sort === 'status')
                                    <i class="bi bi-arrow-{{ $direction === 'asc' ? 'up' : 'down' }}"></i>
                                @else
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                @endif
                            </a>
                        </th>
                        <th>{{ trans('messages.actions') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($invoices as $invoice)
                    <tr>
                        @can('invoices.bulk_delete')
                        <td>
                            <input type="checkbox" class="item-checkbox" value="{{ $invoice->id }}">
                        </td>
                        @endcan
                        <td><a href="{{ route('invoices.show', $invoice) }}">{{ $invoice->invoice_number }}</a></td>
                        <td>{{ $invoice->customer?->name ?? $invoice->customer_name }}</td>
                        <td>{{ $invoice->created_at->format('Y-m-d') }}</td>
                        <td>{{ format_currency($invoice->total) }}</td>
                        <td>{{ format_currency($invoice->paid_amount) }}</td>
                        <td><span class="badge bg-{{ $invoice->due_amount > 0 ? 'warning' : 'success' }}">{{ format_currency($invoice->due_amount) }}</span></td>
                        <td>
                            @php
                                $badgeClass = match($invoice->status) {
                                    'paid' => 'success',
                                    'partially_paid' => 'warning',
                                    'draft' => 'secondary',
                                    'returned' => 'danger',
                                    default => 'info'
                                };
                            @endphp
                            <span class="badge bg-{{ $badgeClass }}">{{ trans('messages.' . $invoice->status) }}</span>
                        </td>
                        <td>
                            @can('invoices.view')
                                <a href="{{ route('invoices.show', $invoice) }}" class="btn btn-sm btn-info" title="{{ trans('messages.view') ?? 'View' }}"><i class="bi bi-eye"></i></a>
                            @endcan
                            @can('invoices.pdf')
                                <a href="{{ route('invoices.pdf', $invoice) }}" class="btn btn-sm btn-secondary" title="{{ trans('messages.download_pdf') }}" target="_blank"><i class="bi bi-file-pdf"></i></a>
                            @endcan
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="{{ auth()->user()->can('invoices.bulk_delete') ? '9' : '8' }}" class="text-center">{{ trans('messages.no_invoices_found') }}</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        </form>

        {{ $invoices->links() }}
    </div>
</div>

@include('partials.bulk-delete-modal')
@endsection
