@php
    $storeName = \App\Models\Setting::get('store_name', 'Gestock Pro');
    $storeLogo = \App\Models\Setting::get('store_logo');
    $currency = currency_symbol();
    $footerText = \App\Models\Setting::get('invoice_footer_text', '');
    $locale = app()->getLocale();
    $isRTL = $locale === 'ar';
    $dir = $isRTL ? 'rtl' : 'ltr';
    $showLogo = \App\Models\Setting::get('invoice_show_logo', '1') === '1';
    $autoPrintFromUrl = request()->get('auto_print') === '1' || request()->get('auto_print') === 'true';
@endphp
<!DOCTYPE html>
<html lang="{{ $locale }}" dir="{{ $dir }}">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ trans('messages.invoices') }} {{ $invoice->invoice_number }}</title>
    <link rel="stylesheet" href="{{ asset('lib/fonts/google-fonts.css') }}">
    <style>
        @charset "UTF-8";
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: {{ $isRTL ? "'Cairo', 'DejaVu Sans', sans-serif" : "'Cabin', 'DejaVu Sans', sans-serif" }};
            direction: {{ $dir }};
            font-size: 14px;
            color: #333;
            padding: 20px;
            background-color: #f5f5f5;
            unicode-bidi: embed;
        }
        
        @if($isRTL)
        * {
            font-family: 'Cairo', 'DejaVu Sans', sans-serif !important;
        }
        @else
        * {
            font-family: 'Cabin', 'DejaVu Sans', sans-serif !important;
        }
        @endif
        
        .print-header {
            background-color: #fff;
            padding: 15px 20px;
            margin-bottom: 20px;
            border-radius: 5px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .print-button {
            background-color: #007bff;
            color: white;
            border: none;
            padding: 10px 20px;
            font-size: 16px;
            border-radius: 5px;
            cursor: pointer;
            {{ $isRTL ? 'margin-right: auto;' : 'margin-left: auto;' }}
            transition: background-color 0.3s;
        }
        
        .print-button:hover {
            background-color: #0056b3;
        }
        
        .print-button:active {
            background-color: #004085;
        }
        
        @media print {
            .print-header {
                display: none;
            }
            
            body {
                background-color: #fff;
                padding: 0;
            }
        }
        
        .invoice-container {
            background-color: #fff;
            padding: 30px;
            border-radius: 5px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        
        .header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
            border-bottom: 2px solid #333;
            padding-bottom: 20px;
        }
        
        .logo-container {
            {{ $isRTL ? 'text-align: right;' : 'text-align: left;' }}
        }
        
        .logo-container img {
            max-height: 80px;
            max-width: 200px;
        }
        
        .invoice-info {
            {{ $isRTL ? 'text-align: left;' : 'text-align: right;' }}
        }
        
        .invoice-info h2 {
            margin-bottom: 10px;
            color: #333;
            font-size: 24px;
        }
        
        .invoice-details {
            display: flex;
            justify-content: space-between;
            margin-bottom: 30px;
            flex-wrap: wrap;
        }
        
        .customer-info, .invoice-meta {
            width: 48%;
            min-width: 250px;
        }
        
        .customer-info h3, .invoice-meta h3 {
            margin-bottom: 10px;
            font-size: 16px;
            border-bottom: 1px solid #ddd;
            padding-bottom: 5px;
            color: #333;
        }
        
        .customer-info p, .invoice-meta p {
            margin: 5px 0;
            line-height: 1.6;
        }
        
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 20px;
        }
        
        th, td {
            border: 1px solid #ddd;
            padding: 12px;
            text-align: {{ $isRTL ? 'right' : 'left' }};
        }
        
        th {
            background-color: #f2f2f2;
            font-weight: bold;
            color: #333;
        }
        
        tbody tr:nth-child(even) {
            background-color: #f9f9f9;
        }
        
        tbody tr:hover {
            background-color: #f5f5f5;
        }
        
        .text-{{ $isRTL ? 'start' : 'end' }} {
            text-align: {{ $isRTL ? 'left' : 'right' }};
        }
        
        .total-table {
            width: 100%;
            max-width: 400px;
            margin-top: 20px;
            {{ $isRTL ? 'margin-right: auto;' : 'margin-left: auto;' }}
            border-collapse: collapse;
        }
        
        .total-table td {
            padding: 8px 15px;
            border: 1px solid #ddd;
            {{ $isRTL ? 'text-align: right;' : 'text-align: left;' }}
        }
        
        .total-table td:first-child {
            font-weight: bold;
            background-color: #f9f9f9;
            {{ $isRTL ? 'text-align: right;' : 'text-align: left;' }}
        }
        
        .total-table td:last-child {
            {{ $isRTL ? 'text-align: left;' : 'text-align: right;' }}
            font-weight: normal;
        }
        
        .total-table .total-row td {
            background-color: #e9ecef;
            font-weight: bold;
            font-size: 16px;
            border-top: 2px solid #333;
        }
        
        .total-table .total-row td:last-child {
            {{ $isRTL ? 'text-align: left;' : 'text-align: right;' }}
        }
        
        .footer {
            margin-top: 40px;
            padding-top: 20px;
            border-top: 1px solid #ddd;
            {{ $isRTL ? 'text-align: right;' : 'text-align: left;' }}
            font-size: 12px;
            color: #666;
        }
        
        .notes {
            margin-top: 20px;
            padding: 15px;
            background-color: #f9f9f9;
            border-radius: 5px;
            border-right: {{ $isRTL ? '4px solid #007bff;' : 'none' }};
            border-left: {{ $isRTL ? 'none' : '4px solid #007bff;' }};
        }
        
        .notes strong {
            display: block;
            margin-bottom: 8px;
            color: #333;
        }
    </style>
</head>
<body>
    <div class="print-header">
        <h3>{{ trans('messages.invoices') }} #{{ $invoice->invoice_number }}</h3>
        <div>
            <button type="button" id="print-btn" class="print-button" onclick="window.print()">
                <i class="bi bi-printer"></i> {{ trans('messages.print') }}
            </button>
            <button type="button" id="close-btn" class="print-button" onclick="closePrintWindow()" style="background-color: #6c757d; margin-{{ $isRTL ? 'right' : 'left' }}: 10px;">
                <i class="bi bi-x-circle"></i> {{ trans('messages.close') }}
            </button>
        </div>
    </div>
    
    <div class="invoice-container">
        <div class="header">
            <div class="logo-container">
                @if($showLogo && $storeLogo)
                    <img src="{{ storage_url( $storeLogo) }}" alt="{{ $storeName }}">
                @else
                    <h2>{{ $storeName }}</h2>
                @endif
            </div>
            <div class="invoice-info">
                <h2>{{ trans('messages.invoices') }} #{{ $invoice->invoice_number }}</h2>
                <p><strong>{{ trans('messages.date') }}:</strong> {{ $invoice->created_at->format('Y-m-d') }}</p>
                <p><strong>{{ trans('messages.status') }}:</strong> {{ trans('messages.' . $invoice->status) }}</p>
            </div>
        </div>

        <div class="invoice-details">
            <div class="customer-info">
                <h3>{{ trans('messages.customer') }}</h3>
                <p><strong>{{ trans('messages.name') }}:</strong> {{ $invoice->customer?->name ?? $invoice->customer_name }}</p>
                @if($invoice->customer)
                    @if($invoice->customer->email)
                        <p><strong>{{ trans('messages.email') }}:</strong> {{ $invoice->customer->email }}</p>
                    @endif
                    @if($invoice->customer->phone)
                        <p><strong>{{ trans('messages.phone') }}:</strong> {{ $invoice->customer->phone }}</p>
                    @endif
                    @if($invoice->customer->address)
                        <p><strong>{{ trans('messages.address') }}:</strong> {{ $invoice->customer->address }}</p>
                    @endif
                @endif
            </div>
            <div class="invoice-meta">
                <h3>{{ trans('messages.invoice_details') }}</h3>
                <p><strong>{{ trans('messages.created_by') }}:</strong> {{ $invoice->user->name }}</p>
                <p><strong>{{ trans('messages.invoice_number') }}:</strong> {{ $invoice->invoice_number }}</p>
            </div>
        </div>

        <table>
            <thead>
                <tr>
                    <th>{{ trans('messages.products') }}</th>
                    <th>{{ trans('messages.quantity') }}</th>
                    <th>{{ trans('messages.unit_price') }}</th>
                    <th>{{ trans('messages.tax') }}</th>
                    <th>{{ trans('messages.discount') }}</th>
                    <th>{{ trans('messages.total') }}</th>
                </tr>
            </thead>
            <tbody>
                @foreach($invoice->items as $item)
                <tr>
                    <td>{{ $item->product->name }}</td>
                    <td>{{ $item->quantity }}</td>
                    <td>{{ number_format($item->unit_price, 2) }} {{ $currency }}</td>
                    <td>{{ $item->tax_rate }}%</td>
                    <td>{{ number_format($item->discount, 2) }} {{ $currency }}</td>
                    <td>{{ number_format($item->total, 2) }} {{ $currency }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>

        <table class="total-table">
            <tr>
                <td>{{ trans('messages.subtotal') }}</td>
                <td>{{ number_format($invoice->subtotal, 2) }} {{ $currency }}</td>
            </tr>
            @if($invoice->discount > 0)
            <tr>
                <td>{{ trans('messages.discount') }}</td>
                <td>-{{ number_format($invoice->discount, 2) }} {{ $currency }}</td>
            </tr>
            @endif
            <tr>
                <td>{{ trans('messages.tax') }}</td>
                <td>{{ number_format($invoice->tax, 2) }} {{ $currency }}</td>
            </tr>
            <tr class="total-row">
                <td>{{ trans('messages.total') }}</td>
                <td>{{ number_format($invoice->total, 2) }} {{ $currency }}</td>
            </tr>
            <tr>
                <td>{{ trans('messages.paid') }}</td>
                <td>{{ number_format($invoice->paid_amount, 2) }} {{ $currency }}</td>
            </tr>
            <tr>
                <td>{{ trans('messages.due') }}</td>
                <td style="font-weight: bold;">{{ number_format($invoice->due_amount, 2) }} {{ $currency }}</td>
            </tr>
        </table>

        @if($invoice->notes)
        <div class="notes">
            <strong>{{ trans('messages.notes') }}:</strong>
            <p>{{ $invoice->notes }}</p>
        </div>
        @endif

        @if($footerText)
        <div class="footer">
            <p>{{ $footerText }}</p>
        </div>
        @endif
    </div>

<script>
    // Function to close print window
    function closePrintWindow() {
        // Try to close the window
        try {
            // Check if window was opened by JavaScript (has opener or is a popup)
            if (window.opener || window.history.length <= 1) {
                window.close();
            } else {
                // If can't close (some browsers block this), redirect to invoice show page
                const invoiceId = {{ $invoice->id }};
                const showUrl = '{{ route('invoices.show', $invoice) }}';
                window.location.href = showUrl;
            }
        } catch (e) {
            // Fallback: redirect to invoice show page
            const invoiceId = {{ $invoice->id }};
            const showUrl = '{{ route('invoices.show', $invoice) }}';
            window.location.href = showUrl;
        }
    }
    
    // Auto print when page loads (if coming from POS)
    @if($autoPrintFromUrl)
    (function() {
        console.log('Auto print is enabled for this invoice');
        
        // Function to trigger print
        function doPrint() {
            try {
                console.log('Triggering print dialog...');
                window.print();
            } catch (e) {
                console.error('Print error:', e);
            }
        }
        
        // Try printing when DOM is ready
        if (document.readyState === 'loading') {
            document.addEventListener('DOMContentLoaded', function() {
                console.log('DOM loaded, scheduling print...');
                setTimeout(doPrint, 1200);
            });
        } else if (document.readyState === 'interactive') {
            console.log('DOM interactive, scheduling print...');
            setTimeout(doPrint, 1200);
        } else {
            // Document is already loaded
            console.log('Document ready, scheduling print...');
            setTimeout(doPrint, 800);
        }
        
        // Also try on window load as backup
        window.addEventListener('load', function() {
            console.log('Window loaded, scheduling print as backup...');
            setTimeout(doPrint, 1500);
        });
    })();
    @endif
</script>
</body>
</html>

