@php
    $locale = app()->getLocale();
    $isRTL = $locale === 'ar';
    $dir = $isRTL ? 'rtl' : 'ltr';
    $lang = $locale;
    $storeName = \App\Models\Setting::get('store_name', 'Gestock Pro');
    $storeLogo = \App\Models\Setting::get('store_logo');
    $currency = \App\Models\Setting::get('currency', '$');
@endphp
<!DOCTYPE html>
<html lang="{{ $lang }}" dir="{{ $dir }}">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <title>@yield('title', $storeName)</title>
    
    <!-- Custom Fonts - Load both fonts for all languages -->
    <link rel="stylesheet" href="{{ asset('lib/fonts/google-fonts.css') }}">
    <!-- Bootstrap 5 CSS (RTL or LTR based on language) -->
    @if($isRTL)
        <link href="{{ asset('lib/css/bootstrap.rtl.min.css') }}" rel="stylesheet">
    @else
        <link href="{{ asset('lib/css/bootstrap.min.css') }}" rel="stylesheet">
    @endif
    <!-- Bootstrap Icons -->
    <link rel="stylesheet" href="{{ asset('lib/icons/bootstrap-icons/bootstrap-icons.css') }}">
    <!-- Flag Icons -->
    <link rel="stylesheet" href="{{ asset('lib/icons/flag-icons/flag-icons.min.css') }}">
    <!-- Custom CSS -->
    <link rel="stylesheet" href="{{ asset('css/custom.css') }}">
    
    @stack('styles')
</head>
<body>
    @auth
        @include('layouts.partials.navbar')
        @include('layouts.partials.sidebar')
    @endauth

    <main class="@auth main-content @endauth">
        <div class="container-fluid">
            @if(session('success'))
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    {{ function_exists('translate_alert_message') ? translate_alert_message(session('success')) : session('success') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            @if(session('error'))
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    {{ function_exists('translate_alert_message') ? translate_alert_message(session('error')) : session('error') }}
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            @if($errors->any())
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <ul class="mb-0">
                        @foreach($errors->all() as $error)
                            <li>{{ $error }}</li>
                        @endforeach
                    </ul>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            @if(session('trial_warning'))
                <div class="alert alert-warning alert-dismissible fade show" role="alert">
                    <i class="bi bi-exclamation-triangle"></i>
                    <strong>تنبيه:</strong> {{ session('trial_warning')['message'] }}
                    <a href="{{ route('license.activate') }}" class="btn btn-sm btn-warning ms-2">
                        <i class="bi bi-key"></i> تفعيل الترخيص الآن
                    </a>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            @endif

            @yield('content')
        </div>
    </main>

    <!-- Footer -->
    <footer class="footer mt-auto bg-light border-top">
        <div class="container-fluid">
            <div class="row align-items-center justify-content-center">
                <div class="col-12 text-center">
                    <div class="footer-text">
                        <strong class="footer-brand">Gestock Pro</strong>
                        <span class="footer-version">v3.25.1</span>
                        <span class="mx-2">|</span>
                        {{ trans('messages.developed_by') }} 
                        <strong class="footer-company">ImraneSoft</strong> 
                        {{ trans('messages.since') }} 2012
                        <span class="mx-2">|</span>
                        {{ trans('messages.last_update') }} 21/01/2025
                    </div>
                </div>
            </div>
        </div>
    </footer>

    <!-- jQuery -->
    <script src="{{ asset('lib/js/jquery-3.7.0.min.js') }}"></script>
    <!-- Bootstrap 5 JS -->
    <script src="{{ asset('lib/js/bootstrap.bundle.min.js') }}"></script>
    <!-- Chart.js -->
    <script src="{{ asset('lib/js/chart.umd.min.js') }}"></script>
    <!-- Custom JS -->
    <script src="{{ asset('js/custom.js') }}"></script>
    
    <!-- Confirm Modal Helper -->
    <script>
        // Helper function to show confirm modal with translations
        function confirmAction(message, title, onConfirm, onCancel) {
            const defaultTitle = title || '{{ trans('messages.confirm') }}';
            const cancelText = '{{ trans('messages.cancel') }}';
            const confirmText = '{{ trans('messages.confirm') }}';
            
            showConfirmModal(message, defaultTitle, onConfirm, onCancel);
        }
    </script>
    
    @stack('scripts')
</body>
</html>
