@php
    $currentLocale = app()->getLocale();
    $locales = [
        'en' => ['name' => 'English', 'flag' => 'gb'],
        'ar' => ['name' => 'العربية', 'flag' => 'ma'],
        'fr' => ['name' => 'Français', 'flag' => 'fr'],
    ];
    $storeName = \App\Models\Setting::get('store_name', 'Gestock Pro');
@endphp
<nav class="navbar navbar-expand-lg navbar-dark bg-primary">
    <div class="container-fluid">
        <button class="sidebar-toggle d-lg-none" type="button" id="sidebarToggleBtn" aria-label="Toggle sidebar">
            <i class="bi bi-list"></i>
        </button>
        <a class="navbar-brand" href="{{ route('dashboard') }}">
            <i class="bi bi-box-seam"></i> <span class="d-none d-sm-inline">Gestock Pro</span>
        </a>
        <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav" aria-expanded="false" aria-label="Toggle navigation">
            <span class="navbar-toggler-icon"></span>
        </button>
        <div class="collapse navbar-collapse" id="navbarNav">
            <ul class="navbar-nav ms-auto">
                @if(auth()->check() && (auth()->user()->hasRole('Super Admin') || auth()->user()->hasRole('Admin')))
                <!-- Treasury Balance Widget -->
                <li class="nav-item me-2">
                    @php
                        $treasuryBalance = \App\Http\Controllers\TreasuryController::getCurrentBalance();
                    @endphp
                    <span class="nav-link text-white" style="font-weight: bold; background-color: {{ $treasuryBalance >= 0 ? 'rgba(40, 167, 69, 0.3)' : 'rgba(220, 53, 69, 0.3)' }}; border-radius: 5px; padding: 5px 10px; border: 1px solid {{ $treasuryBalance >= 0 ? 'rgba(40, 167, 69, 0.5)' : 'rgba(220, 53, 69, 0.5)' }};">
                        <i class="bi bi-cash-coin"></i> {{ trans('messages.current_cash_balance') }}: {{ format_currency($treasuryBalance) }}
                    </span>
                </li>
                @endif
                <!-- Language Switcher -->
                <li class="nav-item dropdown me-2">
                    <a class="nav-link dropdown-toggle" href="#" id="languageDropdown" role="button" data-bs-toggle="dropdown">
                        <i class="bi bi-translate"></i> <span class="fi fi-{{ $locales[$currentLocale]['flag'] }}"></span> {{ $locales[$currentLocale]['name'] }}
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end">
                        @foreach($locales as $code => $locale)
                            @if($code !== $currentLocale)
                                <li>
                                    <a class="dropdown-item" href="{{ route('language.switch', $code) }}">
                                        <span class="fi fi-{{ $locale['flag'] }}"></span> {{ $locale['name'] }}
                                    </a>
                                </li>
                            @endif
                        @endforeach
                    </ul>
                </li>
                <!-- User Menu -->
                <li class="nav-item dropdown">
                    <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown">
                        <i class="bi bi-person-circle"></i> {{ Auth::user()->name }}
                    </a>
                    <ul class="dropdown-menu dropdown-menu-end">
                        <li><a class="dropdown-item" href="{{ route('profile.settings') }}"><i class="bi bi-person"></i> {{ __('messages.profile_settings') }}</a></li>
                        <li><a class="dropdown-item" href="{{ route('settings.index') }}"><i class="bi bi-gear"></i> {{ __('messages.settings') }}</a></li>
                        <li><hr class="dropdown-divider"></li>
                        <li>
                            <form method="POST" action="{{ route('logout') }}">
                                @csrf
                                <button type="submit" class="dropdown-item">
                                    <i class="bi bi-box-arrow-right"></i> {{ __('messages.logout') }}
                                </button>
                            </form>
                        </li>
                    </ul>
                </li>
            </ul>
        </div>
    </div>
</nav>
