@php
    $currentLocale = app()->getLocale();
    $isRTL = $currentLocale === 'ar';
@endphp
<div class="sidebar">
    <ul class="nav flex-column">
        @can('pos.view')
        @if(\App\Models\Setting::get('pos_enabled', '1') === '1')
        <li class="nav-item">
            <a class="nav-link {{ request()->routeIs('pos.*') ? 'active' : '' }}" href="{{ route('pos.index') }}">
                <i class="bi bi-cart"></i> <span>{{ trans('messages.pos') }}</span>
            </a>
        </li>
        @endif
        @endcan
        @can('dashboard.view')
        <li class="nav-item">
            <a class="nav-link {{ request()->routeIs('dashboard') ? 'active' : '' }}" href="{{ route('dashboard') }}">
                <i class="bi bi-speedometer2"></i> <span>{{ trans('messages.dashboard') }}</span>
            </a>
        </li>
        @endcan
        @if(auth()->user()->can('products.view') || auth()->user()->can('categories.view') || request()->routeIs('stock-alerts.*') || request()->routeIs('stock-takes.*'))
        <li class="nav-item">
            <a class="nav-link" 
               data-bs-toggle="collapse" 
               href="#productsMenu" 
               role="button" 
               aria-expanded="{{ (request()->routeIs('products.*') || request()->routeIs('categories.*') || request()->routeIs('stock-alerts.*') || request()->routeIs('stock-takes.*')) ? 'true' : 'false' }}" 
               aria-controls="productsMenu">
                <i class="bi bi-box-seam"></i> <span>{{ trans('messages.products_management') }}</span>
                <i class="bi bi-chevron-{{ $isRTL ? 'left' : 'right' }}" style="margin-{{ $isRTL ? 'right' : 'left' }}: auto;"></i>
            </a>
            <div class="collapse {{ (request()->routeIs('products.*') || request()->routeIs('categories.*') || request()->routeIs('stock-alerts.*') || request()->routeIs('stock-takes.*') || request()->routeIs('warehouses.*')) ? 'show' : '' }}" id="productsMenu">
                <ul class="nav flex-column ms-3">
                    @can('products.view')
                    <li class="nav-item">
                        <a class="nav-link {{ request()->routeIs('products.*') ? 'active' : '' }}" href="{{ route('products.index') }}">
                            <i class="bi bi-box"></i> <span>{{ trans('messages.products') }}</span>
                        </a>
                    </li>
                    @endcan
                    @can('categories.view')
                    <li class="nav-item">
                        <a class="nav-link {{ request()->routeIs('categories.*') ? 'active' : '' }}" href="{{ route('categories.index') }}">
                            <i class="bi bi-tags"></i> <span>{{ trans('messages.categories') }}</span>
                        </a>
                    </li>
                    @endcan
                    @if(\App\Models\Setting::get('warehouse_mode', 'single') === 'multiple')
                    <li class="nav-item">
                        <a class="nav-link {{ request()->routeIs('warehouses.*') ? 'active' : '' }}" href="{{ route('warehouses.index') }}">
                            <i class="bi bi-building"></i> <span>{{ trans('messages.warehouses') }}</span>
                        </a>
                    </li>
                    @endif
                    <li class="nav-item">
                        <a class="nav-link {{ request()->routeIs('stock-alerts.*') ? 'active' : '' }}" href="{{ route('stock-alerts.index') }}">
                            <i class="bi bi-exclamation-triangle"></i> <span>{{ trans('messages.stock_alerts') }}</span>
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link {{ request()->routeIs('stock-takes.*') ? 'active' : '' }}" href="{{ route('stock-takes.index') }}">
                            <i class="bi bi-clipboard-check"></i> <span>{{ trans('messages.stock_takes') }}</span>
                        </a>
                    </li>
                </ul>
            </div>
        </li>
        @endif
        @if(auth()->user()->can('invoices.view') || auth()->user()->can('purchase-invoices.view') || request()->routeIs('purchase-orders.*'))
        <li class="nav-item">
            <a class="nav-link" 
               data-bs-toggle="collapse" 
               href="#invoicesMenu" 
               role="button" 
               aria-expanded="{{ (request()->routeIs('invoices.*') || request()->routeIs('purchase-invoices.*') || request()->routeIs('quotations.*') || request()->routeIs('purchase-orders.*')) ? 'true' : 'false' }}" 
               aria-controls="invoicesMenu">
                <i class="bi bi-receipt-cutoff"></i> <span>{{ trans('messages.invoices') }}</span>
                <i class="bi bi-chevron-{{ $isRTL ? 'left' : 'right' }}" style="margin-{{ $isRTL ? 'right' : 'left' }}: auto;"></i>
            </a>
            <div class="collapse {{ (request()->routeIs('invoices.*') || request()->routeIs('purchase-invoices.*') || request()->routeIs('quotations.*') || request()->routeIs('purchase-orders.*')) ? 'show' : '' }}" id="invoicesMenu">
                <ul class="nav flex-column ms-3">
                    @can('invoices.view')
                    <li class="nav-item">
                        <a class="nav-link {{ request()->routeIs('invoices.*') && !request()->routeIs('quotations.*') ? 'active' : '' }}" href="{{ route('invoices.index') }}">
                            <i class="bi bi-receipt"></i> <span>{{ trans('messages.sales_invoices') }}</span>
                        </a>
                    </li>
                    @endcan
                    @can('purchase-invoices.view')
                    <li class="nav-item">
                        <a class="nav-link {{ request()->routeIs('purchase-invoices.*') ? 'active' : '' }}" href="{{ route('purchase-invoices.index') }}">
                            <i class="bi bi-cart-plus"></i> <span>{{ trans('messages.purchase_invoices') }}</span>
                        </a>
                    </li>
                    @endcan

                    @can('invoices.view')
                    <li class="nav-item">
                        <a class="nav-link {{ request()->routeIs('quotations.*') ? 'active' : '' }}" href="{{ route('quotations.index') }}">
                            <i class="bi bi-file-earmark-text"></i> <span>{{ trans('messages.quotations') }}</span>
                        </a>
                    </li>
                    @endcan
                    <li class="nav-item">
                        <a class="nav-link {{ request()->routeIs('purchase-orders.*') ? 'active' : '' }}" href="{{ route('purchase-orders.index') }}">
                            <i class="bi bi-cart-plus"></i> <span>{{ trans('messages.purchase_orders') }}</span>
                        </a>
                    </li>
                    
                </ul>
            </div>
        </li>
        @endif
        @can('customers.view')
        <li class="nav-item">
            <a class="nav-link {{ request()->routeIs('customers.*') ? 'active' : '' }}" href="{{ route('customers.index') }}">
                <i class="bi bi-people"></i> <span>{{ trans('messages.customers') }}</span>
            </a>
        </li>
        @endcan
        @can('suppliers.view')
        <li class="nav-item">
            <a class="nav-link {{ request()->routeIs('suppliers.*') ? 'active' : '' }}" href="{{ route('suppliers.index') }}">
                <i class="bi bi-truck"></i> <span>{{ trans('messages.suppliers') }}</span>
            </a>
        </li>
        @endcan
        @if(auth()->user()->can('treasury.view') || auth()->user()->can('cheques.view') || auth()->user()->can('promissory-notes.view') || auth()->user()->can('reports.view') || auth()->user()->can('analytics.view'))
        <li class="nav-item">
            <a class="nav-link" 
               data-bs-toggle="collapse" 
               href="#accountingMenu" 
               role="button" 
               aria-expanded="{{ (request()->routeIs('cheques.*') || request()->routeIs('promissory-notes.*') || request()->routeIs('treasury.*') || request()->routeIs('reports.*') || request()->routeIs('analytics.*')) ? 'true' : 'false' }}" 
               aria-controls="accountingMenu">
                <i class="bi bi-calculator"></i> <span>{{ trans('messages.accounting') }}</span>
                <i class="bi bi-chevron-{{ $isRTL ? 'left' : 'right' }}" style="margin-{{ $isRTL ? 'right' : 'left' }}: auto;"></i>
            </a>
            <div class="collapse {{ (request()->routeIs('cheques.*') || request()->routeIs('promissory-notes.*') || request()->routeIs('treasury.*') || request()->routeIs('reports.*') || request()->routeIs('analytics.*')) ? 'show' : '' }}" id="accountingMenu">
                <ul class="nav flex-column ms-3">
                    @can('treasury.view')
                    <li class="nav-item">
                        <a class="nav-link {{ request()->routeIs('treasury.*') ? 'active' : '' }}" href="{{ route('treasury.dashboard') }}">
                            <i class="bi bi-cash-coin"></i> <span>{{ trans('messages.treasury') }}</span>
                        </a>
                    </li>
                    @endcan
                    @can('cheques.view')
                    <li class="nav-item">
                        <a class="nav-link {{ request()->routeIs('cheques.*') ? 'active' : '' }}" href="{{ route('cheques.index') }}">
                            <i class="bi bi-bank"></i> <span>{{ trans('messages.cheques') }}</span>
                        </a>
                    </li>
                    @endcan
                    @can('promissory-notes.view')
                    <li class="nav-item">
                        <a class="nav-link {{ request()->routeIs('promissory-notes.*') ? 'active' : '' }}" href="{{ route('promissory-notes.index') }}">
                            <i class="bi bi-file-text"></i> <span>{{ trans('messages.promissory_notes') }}</span>
                        </a>
                    </li>
                    @endcan
                    @can('reports.view')
                    <li class="nav-item">
                        <a class="nav-link {{ request()->routeIs('reports.*') ? 'active' : '' }}" href="{{ route('reports.index') }}">
                            <i class="bi bi-graph-up"></i> <span>{{ trans('messages.reports') }}</span>
                        </a>
                    </li>
                    @endcan
                    @can('analytics.view')
                    <li class="nav-item">
                        <a class="nav-link {{ request()->routeIs('analytics.*') ? 'active' : '' }}" href="{{ route('analytics.index') }}">
                            <i class="bi bi-bar-chart-line"></i> <span>{{ trans('messages.analytics') }}</span>
                        </a>
                    </li>
                    @endcan
                </ul>
            </div>
        </li>
        @endif
        @if((auth()->user()->can('quality.defects.view') || auth()->user()->can('quality.complaints.view') || auth()->user()->can('quality.reports.view')) && \App\Models\Setting::get('menu_show_quality', '1') === '1')
        <li class="nav-item">
            <a class="nav-link {{ request()->routeIs('quality.*') ? 'active' : '' }}" 
               data-bs-toggle="collapse" 
               href="#qualityMenu" 
               role="button" 
               aria-expanded="{{ request()->routeIs('quality.*') ? 'true' : 'false' }}" 
               aria-controls="qualityMenu">
                <i class="bi bi-shield-check"></i> <span>{{ trans('messages.quality_management') }}</span>
                <i class="bi bi-chevron-{{ $isRTL ? 'left' : 'right' }}" style="margin-{{ $isRTL ? 'right' : 'left' }}: auto;"></i>
            </a>
            <div class="collapse {{ request()->routeIs('quality.*') ? 'show' : '' }}" id="qualityMenu">
                <ul class="nav flex-column ms-3">
                    @can('quality.defects.view')
                    <li class="nav-item">
                        <a class="nav-link {{ request()->routeIs('quality.defects.*') ? 'active' : '' }}" href="{{ route('quality.defects.index') }}">
                            <i class="bi bi-exclamation-triangle"></i> <span>{{ trans('messages.product_defects') }}</span>
                        </a>
                    </li>
                    @endcan
                    @can('quality.complaints.view')
                    <li class="nav-item">
                        <a class="nav-link {{ request()->routeIs('quality.complaints.*') ? 'active' : '' }}" href="{{ route('quality.complaints.index') }}">
                            <i class="bi bi-chat-left-text"></i> <span>{{ trans('messages.quality_complaints') }}</span>
                        </a>
                    </li>
                    @endcan
                    @can('quality.reports.view')
                    <li class="nav-item">
                        <a class="nav-link {{ request()->routeIs('quality.reports.*') ? 'active' : '' }}" href="{{ route('quality.reports.index') }}">
                            <i class="bi bi-file-earmark-bar-graph"></i> <span>{{ trans('messages.quality_reports') }}</span>
                        </a>
                    </li>
                    @endcan
                </ul>
            </div>
        </li>
        @endif
        @if(auth()->user()->can('settings.view') || auth()->user()->can('users.view') || auth()->user()->can('backups.view') || auth()->user()->can('permissions.view') || auth()->user()->can('activity-logs.view'))
        <li class="nav-item">
            <a class="nav-link" 
               data-bs-toggle="collapse" 
               href="#systemMenu" 
               role="button" 
               aria-expanded="{{ (request()->routeIs('settings.*') || request()->routeIs('users.*') || request()->routeIs('backups.*') || request()->routeIs('permissions.*') || request()->routeIs('activity-logs.*')) ? 'true' : 'false' }}" 
               aria-controls="systemMenu">
                <i class="bi bi-gear-wide-connected"></i> <span>{{ trans('messages.system_management') }}</span>
                <i class="bi bi-chevron-{{ $isRTL ? 'left' : 'right' }}" style="margin-{{ $isRTL ? 'right' : 'left' }}: auto;"></i>
            </a>
            <div class="collapse {{ (request()->routeIs('settings.*') || request()->routeIs('users.*') || request()->routeIs('backups.*') || request()->routeIs('permissions.*') || request()->routeIs('activity-logs.*')) ? 'show' : '' }}" id="systemMenu">
                <ul class="nav flex-column ms-3">
                    @can('settings.view')
                    <li class="nav-item">
                        <a class="nav-link {{ request()->routeIs('settings.*') ? 'active' : '' }}" href="{{ route('settings.index') }}">
                            <i class="bi bi-gear"></i> <span>{{ trans('messages.settings') }}</span>
                        </a>
                    </li>
                    @endcan
                    @can('users.view')
                    <li class="nav-item">
                        <a class="nav-link {{ request()->routeIs('users.*') ? 'active' : '' }}" href="{{ route('users.index') }}">
                            <i class="bi bi-person-gear"></i> <span>{{ trans('messages.users') }}</span>
                        </a>
                    </li>
                    @endcan
                    @can('permissions.view')
                    <li class="nav-item">
                        <a class="nav-link {{ request()->routeIs('permissions.*') ? 'active' : '' }}" href="{{ route('permissions.index') }}">
                            <i class="bi bi-shield-lock"></i> <span>{{ trans('messages.permissions_management') }}</span>
                        </a>
                    </li>
                    @endcan
                    @can('activity-logs.view')
                    <li class="nav-item">
                        <a class="nav-link {{ request()->routeIs('activity-logs.*') ? 'active' : '' }}" href="{{ route('activity-logs.index') }}">
                            <i class="bi bi-clock-history"></i> <span>{{ trans('messages.activity_logs') }}</span>
                        </a>
                    </li>
                    @endcan
                    @can('backups.view')
                    <li class="nav-item">
                        <a class="nav-link {{ request()->routeIs('backups.*') ? 'active' : '' }}" href="{{ route('backups.index') }}">
                            <i class="bi bi-database"></i> <span>{{ trans('messages.database_backup') }}</span>
                        </a>
                    </li>
                    @endcan
                </ul>
            </div>
        </li>
        @endif
        @can('user-guide.view')
        <li class="nav-item">
            <a class="nav-link {{ request()->routeIs('user-guide.*') ? 'active' : '' }}" href="{{ route('user-guide.index') }}">
                <i class="bi bi-book"></i> <span>{{ trans('messages.user_guide') }}</span>
            </a>
        </li>
        @endcan
    </ul>
</div>
