@extends('layouts.master')

@section('title', trans('messages.permissions_management'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.permissions_management') }}</h2>
</div>

<div class="row g-3 mb-4">
    <!-- Users List -->
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.users') }}</h5>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="table table-striped">
                        <thead>
                            <tr>
                                <th>{{ trans('messages.name') }}</th>
                                <th>{{ trans('messages.email') }}</th>
                                <th>{{ trans('messages.roles') }}</th>
                                <th>{{ trans('messages.permissions') }}</th>
                                <th>{{ trans('messages.actions') }}</th>
                            </tr>
                        </thead>
                        <tbody>
                            @forelse($users as $user)
                            <tr>
                                <td>{{ $user->name }}</td>
                                <td>{{ $user->email }}</td>
                                <td>
                                    @foreach($user->roles as $role)
                                        <span class="badge bg-primary">{{ $role->name }}</span>
                                    @endforeach
                                </td>
                                <td>
                                    @php
                                        $directPermissions = $user->permissions->pluck('name')->toArray();
                                        $rolePermissions = $user->getAllPermissions()->pluck('name')->toArray();
                                        $customPermissions = array_diff($directPermissions, $rolePermissions);
                                    @endphp
                                    @if(count($customPermissions) > 0)
                                        <span class="badge bg-info">{{ count($customPermissions) }} {{ trans('messages.custom') }}</span>
                                    @else
                                        <span class="text-muted">-</span>
                                    @endif
                                </td>
                                <td>
                                    <a href="{{ route('permissions.user', $user) }}" class="btn btn-sm btn-primary">
                                        <i class="bi bi-gear"></i> {{ trans('messages.manage') }}
                                    </a>
                                </td>
                            </tr>
                            @empty
                            <tr>
                                <td colspan="5" class="text-center">{{ trans('messages.no_users_found') }}</td>
                            </tr>
                            @endforelse
                        </tbody>
                    </table>
                </div>
                <div class="mt-3">
                    {{ $users->links() }}
                </div>
            </div>
        </div>
    </div>
</div>

<div class="row g-3">
    <!-- Roles -->
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.roles') }}</h5>
            </div>
            <div class="card-body">
                <form method="POST" action="{{ route('permissions.role.create') }}" class="mb-3">
                    @csrf
                    <div class="input-group">
                        <input type="text" name="name" class="form-control @error('name') is-invalid @enderror" placeholder="{{ trans('messages.role_name') }}" value="{{ old('name') }}" required>
                        <button type="submit" class="btn btn-primary">{{ trans('messages.add') }}</button>
                    </div>
                    @error('name')
                        <div class="text-danger small mt-1">{{ $message }}</div>
                    @enderror
                </form>
                <div class="list-group">
                    @forelse($roles as $role)
                    <div class="list-group-item">
                        <div class="d-flex justify-content-between align-items-center">
                            <div>
                                <strong>{{ $role->name }}</strong>
                                <small class="text-muted d-block">{{ $role->permissions->count() }} {{ trans('messages.permissions') }}</small>
                            </div>
                            <div class="btn-group">
                                <button type="button" class="btn btn-sm btn-outline-primary" data-bs-toggle="modal" data-bs-target="#rolePermissionsModal{{ $role->id }}">
                                    <i class="bi bi-gear"></i>
                                </button>
                                @php
                                    $defaultRoles = ['Super Admin', 'Admin', 'Cashier', 'Warehouse'];
                                    $canDelete = !in_array($role->name, $defaultRoles);
                                @endphp
                                @if($canDelete)
                                <form method="POST" action="{{ route('permissions.role.destroy', $role) }}" class="d-inline" onsubmit="return confirm('{{ trans('messages.confirm_delete') }}');">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-outline-danger">
                                        <i class="bi bi-trash"></i>
                                    </button>
                                </form>
                                @endif
                            </div>
                        </div>
                    </div>

                    <!-- Role Permissions Modal -->
                    <div class="modal fade" id="rolePermissionsModal{{ $role->id }}" tabindex="-1">
                        <div class="modal-dialog modal-lg">
                            <div class="modal-content">
                                <div class="modal-header">
                                    <h5 class="modal-title">{{ trans('messages.manage_permissions') }} - {{ $role->name }}</h5>
                                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                                </div>
                                <form method="POST" action="{{ route('permissions.role.permissions', $role) }}">
                                    @csrf
                                    <div class="modal-body">
                                        @foreach($permissions as $group => $groupPermissions)
                                        <div class="mb-3">
                                            <h6>{{ ucfirst($group) }}</h6>
                                            <div class="row">
                                                @foreach($groupPermissions as $permission)
                                                <div class="col-md-6 mb-2">
                                                    <div class="form-check">
                                                        <input class="form-check-input" type="checkbox" name="permissions[]" 
                                                               value="{{ $permission->id }}" 
                                                               id="role_perm_{{ $role->id }}_{{ $permission->id }}"
                                                               {{ $role->hasPermissionTo($permission) ? 'checked' : '' }}>
                                                        <label class="form-check-label" for="role_perm_{{ $role->id }}_{{ $permission->id }}">
                                                            {{ $permission->name }}
                                                        </label>
                                                    </div>
                                                </div>
                                                @endforeach
                                            </div>
                                        </div>
                                        @endforeach
                                    </div>
                                    <div class="modal-footer">
                                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ trans('messages.cancel') }}</button>
                                        <button type="submit" class="btn btn-primary">{{ trans('messages.save') }}</button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    @empty
                    <div class="list-group-item text-center text-muted">{{ trans('messages.no_roles_found') }}</div>
                    @endforelse
                </div>
            </div>
        </div>
    </div>

    <!-- Permissions -->
    <div class="col-md-6">
        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.permissions') }}</h5>
            </div>
            <div class="card-body">
                <form method="POST" action="{{ route('permissions.permission.create') }}" class="mb-3">
                    @csrf
                    <div class="input-group">
                        <input type="text" name="name" class="form-control @error('name') is-invalid @enderror" placeholder="{{ trans('messages.permission_name') }}" value="{{ old('name') }}" required>
                        <button type="submit" class="btn btn-primary">{{ trans('messages.add') }}</button>
                    </div>
                    @error('name')
                        <div class="text-danger small mt-1">{{ $message }}</div>
                    @enderror
                </form>
                <div class="accordion" id="permissionsAccordion">
                    @foreach($permissions as $group => $groupPermissions)
                    <div class="accordion-item">
                        <h2 class="accordion-header">
                            <button class="accordion-button collapsed" type="button" data-bs-toggle="collapse" data-bs-target="#collapse{{ $loop->index }}">
                                {{ ucfirst($group) }} ({{ count($groupPermissions) }})
                            </button>
                        </h2>
                        <div id="collapse{{ $loop->index }}" class="accordion-collapse collapse" data-bs-parent="#permissionsAccordion">
                            <div class="accordion-body">
                                <ul class="list-unstyled mb-0">
                                    @foreach($groupPermissions as $permission)
                                    <li class="mb-2 d-flex justify-content-between align-items-center">
                                        <span><i class="bi bi-shield-check text-primary"></i> {{ $permission->name }}</span>
                                        <form method="POST" action="{{ route('permissions.permission.destroy', $permission) }}" class="d-inline" onsubmit="return confirm('{{ trans('messages.confirm_delete') }}');">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-outline-danger">
                                                <i class="bi bi-trash"></i>
                                            </button>
                                        </form>
                                    </li>
                                    @endforeach
                                </ul>
                            </div>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>
        </div>
    </div>
</div>
@endsection

