@php
    $storeName = \App\Models\Setting::get('store_name', 'Gestock Pro');
    $storeLogo = \App\Models\Setting::get('store_logo');
    $currency = currency_symbol();
    $locale = app()->getLocale();
    $isRTL = $locale === 'ar';
    $dir = $isRTL ? 'rtl' : 'ltr';
@endphp
<!DOCTYPE html>
<html lang="{{ $locale }}" dir="{{ $dir }}">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ trans('messages.receipt') }}</title>
    <link rel="stylesheet" href="{{ asset('lib/fonts/google-fonts.css') }}">
    <style>
        @charset "UTF-8";
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: {{ $isRTL ? "'Cairo', 'DejaVu Sans', sans-serif" : "'Cabin', 'DejaVu Sans', sans-serif" }};
            direction: {{ $dir }};
            font-size: 12px;
            color: #000;
            background-color: #fff;
            padding: 10px;
            width: 80mm; /* Standard thermal printer width */
            margin: 0 auto;
            unicode-bidi: embed;
        }
        
        @media print {
            body {
                padding: 5px;
            }
            
            .no-print {
                display: none !important;
            }
        }
        
        @if($isRTL)
        * {
            font-family: 'Cairo', 'DejaVu Sans', sans-serif !important;
        }
        @else
        * {
            font-family: 'Cabin', 'DejaVu Sans', sans-serif !important;
        }
        @endif
        
        .ticket {
            width: 100%;
            max-width: 80mm;
            margin: 0 auto;
        }
        
        .header {
            text-align: center;
            border-bottom: 2px dashed #000;
            padding-bottom: 10px;
            margin-bottom: 10px;
        }
        
        .header h1 {
            font-size: 18px;
            font-weight: bold;
            margin-bottom: 5px;
            text-transform: uppercase;
        }
        
        .header .logo {
            max-width: 60px;
            max-height: 60px;
            margin: 0 auto 5px;
        }
        
        .header .date {
            font-size: 10px;
            color: #666;
        }
        
        .info {
            margin-bottom: 10px;
            padding-bottom: 10px;
            border-bottom: 1px dashed #ccc;
        }
        
        .info-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 3px;
            font-size: 11px;
        }
        
        .info-label {
            font-weight: bold;
        }
        
        .items {
            margin-bottom: 10px;
        }
        
        .item-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 5px;
            padding-bottom: 5px;
            border-bottom: 1px dotted #ddd;
            font-size: 11px;
        }
        
        .item-name {
            flex: 1;
            {{ $isRTL ? 'text-align: right;' : 'text-align: left;' }}
            margin-{{ $isRTL ? 'left' : 'right' }}: 5px;
        }
        
        .item-details {
            {{ $isRTL ? 'text-align: left;' : 'text-align: right;' }}
            font-size: 10px;
            color: #666;
        }
        
        .item-price {
            {{ $isRTL ? 'text-align: left;' : 'text-align: right;' }}
            min-width: 60px;
            font-weight: bold;
        }
        
        .totals {
            margin-top: 10px;
            padding-top: 10px;
            border-top: 2px dashed #000;
        }
        
        .total-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 5px;
            font-size: 12px;
        }
        
        .total-row.grand-total {
            font-size: 16px;
            font-weight: bold;
            margin-top: 10px;
            padding-top: 10px;
            border-top: 2px solid #000;
        }
        
        .total-label {
            font-weight: bold;
        }
        
        .footer {
            text-align: center;
            margin-top: 15px;
            padding-top: 10px;
            border-top: 1px dashed #ccc;
            font-size: 10px;
            color: #666;
        }
        
        .print-btn {
            text-align: center;
            margin: 20px 0;
        }
        
        .print-btn button {
            background-color: #007bff;
            color: white;
            border: none;
            padding: 10px 20px;
            font-size: 14px;
            cursor: pointer;
            border-radius: 5px;
        }
        
        .print-btn button:hover {
            background-color: #0056b3;
        }
        
        .separator {
            text-align: center;
            margin: 10px 0;
            font-size: 14px;
        }
    </style>
</head>
<body>
    <div class="ticket">
        <div class="header">
            @if($storeLogo)
                <img src="{{ storage_url( $storeLogo) }}" alt="{{ $storeName }}" class="logo">
            @endif
            <h1>{{ $storeName }}</h1>
            <div class="date">{{ now()->format('Y-m-d H:i:s') }}</div>
        </div>
        
        <div class="info">
            <div class="info-row">
                <span class="info-label">{{ trans('messages.customer') }}:</span>
                <span>{{ $customerName }}</span>
            </div>
        </div>
        
        <div class="items">
            @foreach($cart as $item)
            @php
                $itemSubtotal = $item['unit_price'] * $item['quantity'];
                $itemDiscount = $item['discount'] ?? 0;
                $itemAfterDiscount = $itemSubtotal - $itemDiscount;
                $itemTax = $itemAfterDiscount * (($item['tax_rate'] ?? 0) / 100);
                $itemTotal = $itemAfterDiscount + $itemTax;
            @endphp
            <div class="item-row">
                <div class="item-name">
                    {{ $isRTL && isset($item['name_ar']) && $item['name_ar'] ? $item['name_ar'] : $item['name'] }}
                </div>
                <div class="item-details">
                    <div>{{ $item['quantity'] }} x {{ number_format($item['unit_price'], 2) }} {{ $currency }}</div>
                    @if($itemDiscount > 0)
                        <div style="color: #28a745;">{{ trans('messages.discount') }}: -{{ number_format($itemDiscount, 2) }} {{ $currency }}</div>
                    @endif
                    @if(isset($item['tax_rate']) && $item['tax_rate'] > 0)
                        <div>{{ trans('messages.tax') }}: {{ $item['tax_rate'] }}%</div>
                    @endif
                </div>
                <div class="item-price">
                    {{ number_format($itemTotal, 2) }} {{ $currency }}
                </div>
            </div>
            @endforeach
        </div>
        
        <div class="totals">
            <div class="total-row">
                <span class="total-label">{{ trans('messages.subtotal') }}:</span>
                <span>{{ number_format($subtotal, 2) }} {{ $currency }}</span>
            </div>
            @if(isset($discount) && $discount > 0)
            <div class="total-row" style="color: #28a745;">
                <span class="total-label">{{ trans('messages.discount') }}:</span>
                <span>-{{ number_format($discount, 2) }} {{ $currency }}</span>
            </div>
            @endif
            @if($tax > 0)
            <div class="total-row">
                <span class="total-label">{{ trans('messages.tax') }}:</span>
                <span>{{ number_format($tax, 2) }} {{ $currency }}</span>
            </div>
            @endif
            <div class="total-row grand-total">
                <span class="total-label">{{ trans('messages.total') }}:</span>
                <span>{{ number_format($total, 2) }} {{ $currency }}</span>
            </div>
        </div>
        
        <div class="footer">
            <div class="separator">━━━━━━━━━━━━━━</div>
            <div>{{ trans('messages.thank_you') }}</div>
            <div style="margin-top: 5px;">{{ trans('messages.visit_again') }}</div>
        </div>
    </div>
    
    <div class="print-btn no-print">
        <button onclick="window.print()">
            <i class="bi bi-printer"></i> {{ trans('messages.print') }}
        </button>
    </div>
    
    <script>
        // Auto print when page loads
        window.onload = function() {
            setTimeout(function() {
                window.print();
            }, 500);
        };
    </script>
</body>
</html>

