@extends('layouts.master')

@section('title', trans('messages.edit_product'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.edit_product') }}</h2>
    <a href="{{ route('products.index') }}" class="btn btn-secondary">{{ trans('messages.back') }}</a>
</div>

<div class="card">
    <div class="card-body">
        <form method="POST" action="{{ route('products.update', $product) }}" enctype="multipart/form-data">
            @csrf
            @method('PUT')
            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="sku" class="form-label">{{ trans('messages.sku') }} *</label>
                        <div class="input-group">
                            <input type="text" class="form-control @error('sku') is-invalid @enderror" id="sku" name="sku" value="{{ old('sku', $product->sku) }}" 
                                @if($skuGenerationMode === 'auto') readonly @else required @endif>
                            <span class="input-group-text" id="sku_status_icon" style="display: none;">
                                <i class="bi" id="sku_icon"></i>
                            </span>
                        </div>
                        @if($skuGenerationMode === 'auto')
                            <small class="text-muted">{{ trans('messages.sku_will_be_generated_automatically') }}</small>
                        @endif
                        @error('sku')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <div class="invalid-feedback" id="sku_availability_message" style="display: none;"></div>
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="barcode" class="form-label">{{ trans('messages.barcode') }}</label>
                        <input type="text" class="form-control @error('barcode') is-invalid @enderror" id="barcode" name="barcode" value="{{ old('barcode', $product->barcode) }}">
                        @error('barcode')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="name" class="form-label">{{ trans('messages.name') }} *</label>
                        <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" name="name" value="{{ old('name', $product->name) }}" required>
                        @error('name')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="name_ar" class="form-label">{{ trans('messages.name_ar') }}</label>
                        <input type="text" class="form-control @error('name_ar') is-invalid @enderror" id="name_ar" name="name_ar" value="{{ old('name_ar', $product->name_ar) }}">
                        @error('name_ar')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="brand" class="form-label">{{ trans('messages.brand') }}</label>
                        <input type="text" class="form-control @error('brand') is-invalid @enderror" id="brand" name="brand" value="{{ old('brand', $product->brand) }}">
                        @error('brand')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="category_id" class="form-label">{{ trans('messages.category') }}</label>
                        <div class="input-group">
                            <select class="form-select @error('category_id') is-invalid @enderror" id="category_id" name="category_id">
                                <option value="">{{ trans('messages.select_category') }}</option>
                                @foreach($categories as $category)
                                    <option value="{{ $category->id }}" {{ old('category_id', $product->category_id) == $category->id ? 'selected' : '' }}>{{ $category->name }}</option>
                                @endforeach
                            </select>
                            <button type="button" class="btn btn-outline-primary" data-bs-toggle="modal" data-bs-target="#addCategoryModal">
                                <i class="bi bi-plus-circle"></i> {{ trans('messages.add_category') }}
                            </button>
                        </div>
                        @error('category_id')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="unit" class="form-label">{{ trans('messages.unit') }} *</label>
                        <input type="text" class="form-control @error('unit') is-invalid @enderror" id="unit" name="unit" value="{{ old('unit', $product->unit) }}" required>
                        @error('unit')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-4">
                    <div class="mb-3">
                        <label for="purchase_price" class="form-label">{{ trans('messages.purchase_price') }} *</label>
                        <input type="number" step="0.01" class="form-control @error('purchase_price') is-invalid @enderror" id="purchase_price" name="purchase_price" value="{{ old('purchase_price', $product->purchase_price) }}" required>
                        @error('purchase_price')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="mb-3">
                        <label for="selling_price" class="form-label">{{ trans('messages.selling_price') }} *</label>
                        <input type="number" step="0.01" class="form-control @error('selling_price') is-invalid @enderror" id="selling_price" name="selling_price" value="{{ old('selling_price', $product->selling_price) }}" required>
                        @error('selling_price')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="mb-3">
                        <label for="tax_rate" class="form-label">{{ trans('messages.tax_rate') }}</label>
                        <input type="number" step="0.01" class="form-control @error('tax_rate') is-invalid @enderror" id="tax_rate" name="tax_rate" value="{{ old('tax_rate', $product->tax_rate) }}">
                        @error('tax_rate')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
            <div class="row">
                <div class="col-md-4">
                    <div class="mb-3">
                        <label for="stock_quantity" class="form-label">{{ trans('messages.stock_quantity') }} *</label>
                        <input type="number" class="form-control @error('stock_quantity') is-invalid @enderror" id="stock_quantity" name="stock_quantity" value="{{ old('stock_quantity', $product->stock_quantity) }}" required>
                        @error('stock_quantity')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="mb-3">
                        <label for="reorder_level" class="form-label">{{ trans('messages.reorder_level') }} *</label>
                        <input type="number" class="form-control @error('reorder_level') is-invalid @enderror" id="reorder_level" name="reorder_level" value="{{ old('reorder_level', $product->reorder_level) }}" required>
                        @error('reorder_level')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="mb-3">
                        <label for="image" class="form-label">{{ trans('messages.image') }}</label>
                        @if($product->image)
                            <div class="mb-2">
                                <img src="{{ storage_url( $product->image) }}" alt="{{ $product->name }}" style="max-height: 100px;">
                            </div>
                        @endif
                        <input type="file" class="form-control @error('image') is-invalid @enderror" id="image" name="image" accept="image/*">
                        @error('image')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>
            <div class="mb-3">
                <label for="description" class="form-label">{{ trans('messages.description') }}</label>
                <textarea class="form-control @error('description') is-invalid @enderror" id="description" name="description" rows="3">{{ old('description', $product->description) }}</textarea>
                @error('description')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>
            <button type="submit" class="btn btn-primary">{{ trans('messages.update') }}</button>
        </form>
    </div>
</div>

<!-- Add Category Modal -->
<div class="modal fade" id="addCategoryModal" tabindex="-1" aria-labelledby="addCategoryModalLabel" aria-hidden="true">
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="addCategoryModalLabel">{{ trans('messages.add_category') }}</h5>
                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
            </div>
            <form id="addCategoryForm">
                <div class="modal-body">
                    <div class="mb-3">
                        <label for="new_category_name" class="form-label">{{ trans('messages.name') }} *</label>
                        <input type="text" class="form-control" id="new_category_name" name="name" required>
                        <div class="invalid-feedback" id="category_name_error"></div>
                    </div>
                    <div class="mb-3">
                        <label for="new_category_name_ar" class="form-label">{{ trans('messages.name_ar') }}</label>
                        <input type="text" class="form-control" id="new_category_name_ar" name="name_ar">
                    </div>
                    <div class="mb-3">
                        <label for="new_category_description" class="form-label">{{ trans('messages.description') }}</label>
                        <textarea class="form-control" id="new_category_description" name="description" rows="3"></textarea>
                    </div>
                    <div id="category_error_message" class="alert alert-danger d-none"></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">{{ trans('messages.cancel') }}</button>
                    <button type="submit" class="btn btn-primary" id="saveCategoryBtn">{{ trans('messages.create') }}</button>
                </div>
            </form>
        </div>
    </div>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const skuInput = document.getElementById('sku');
    const skuStatusIcon = document.getElementById('sku_status_icon');
    const skuIcon = document.getElementById('sku_icon');
    const skuAvailabilityMessage = document.getElementById('sku_availability_message');
    const skuGenerationMode = '{{ $skuGenerationMode }}';
    const skuPrefix = '{{ $skuPrefix }}';
    const productId = {{ $product->id }};
    let skuCheckTimeout;

    // Check SKU availability when user stops typing (manual mode)
    if (skuGenerationMode === 'manual') {
        skuInput.addEventListener('input', function() {
            clearTimeout(skuCheckTimeout);
            const sku = this.value.trim();
            
            // Hide status icon while typing
            skuStatusIcon.style.display = 'none';
            skuAvailabilityMessage.style.display = 'none';
            skuInput.classList.remove('is-invalid', 'is-valid');
            
            if (sku.length > 0) {
                // Wait 500ms after user stops typing
                skuCheckTimeout = setTimeout(function() {
                    checkSkuAvailability(sku);
                }, 500);
            }
        });

        skuInput.addEventListener('blur', function() {
            const sku = this.value.trim();
            if (sku.length > 0) {
                checkSkuAvailability(sku);
            }
        });
    }

    function checkSkuAvailability(sku) {
        fetch('{{ route("products.check_sku") }}', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                'Accept': 'application/json'
            },
            body: JSON.stringify({ sku: sku, product_id: productId })
        })
        .then(response => response.json())
        .then(data => {
            skuStatusIcon.style.display = 'flex';
            
            if (data.available) {
                // SKU is available
                skuIcon.className = 'bi bi-check-circle-fill text-success';
                skuInput.classList.remove('is-invalid');
                skuInput.classList.add('is-valid');
                skuAvailabilityMessage.style.display = 'none';
            } else {
                // SKU already exists
                skuIcon.className = 'bi bi-x-circle-fill text-danger';
                skuInput.classList.remove('is-valid');
                skuInput.classList.add('is-invalid');
                skuAvailabilityMessage.textContent = data.message || '{{ trans("messages.sku_already_exists") }}';
                skuAvailabilityMessage.style.display = 'block';
            }
        })
        .catch(error => {
            console.error('Error checking SKU:', error);
        });
    }

    // Original category modal code
    const addCategoryForm = document.getElementById('addCategoryForm');
    const categorySelect = document.getElementById('category_id');
    const modal = new bootstrap.Modal(document.getElementById('addCategoryModal'));
    const errorMessage = document.getElementById('category_error_message');
    const saveBtn = document.getElementById('saveCategoryBtn');

    addCategoryForm.addEventListener('submit', function(e) {
        e.preventDefault();
        
        // Reset error states
        errorMessage.classList.add('d-none');
        document.getElementById('new_category_name').classList.remove('is-invalid');
        saveBtn.disabled = true;
        saveBtn.innerHTML = '<span class="spinner-border spinner-border-sm" role="status" aria-hidden="true"></span> {{ trans("messages.loading") }}...';

        const formData = new FormData(addCategoryForm);
        
        fetch('{{ route("categories.store.ajax") }}', {
            method: 'POST',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                'Accept': 'application/json'
            },
            body: formData
        })
        .then(response => {
            return response.json().then(data => ({
                status: response.status,
                data: data
            }));
        })
        .then(({status, data}) => {
            if (data.success) {
                // Add new category to select
                const newOption = document.createElement('option');
                newOption.value = data.category.id;
                newOption.textContent = data.category.name;
                newOption.selected = true;
                categorySelect.appendChild(newOption);
                
                // Close modal and reset form
                modal.hide();
                addCategoryForm.reset();
                
                // Show success message
                const alertDiv = document.createElement('div');
                alertDiv.className = 'alert alert-success alert-dismissible fade show';
                alertDiv.setAttribute('role', 'alert');
                alertDiv.innerHTML = data.message || '{{ trans("messages.category_created") }}' + 
                    '<button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>';
                document.querySelector('.container-fluid').insertBefore(alertDiv, document.querySelector('.container-fluid').firstChild);
                
                // Auto dismiss after 5 seconds
                setTimeout(() => {
                    alertDiv.remove();
                }, 5000);
            } else {
                // Show error
                if (data.errors && data.errors.name) {
                    document.getElementById('new_category_name').classList.add('is-invalid');
                    document.getElementById('category_name_error').textContent = data.errors.name[0];
                } else {
                    errorMessage.textContent = data.message || '{{ trans("messages.error_occurred") }}';
                    errorMessage.classList.remove('d-none');
                }
            }
        })
        .catch(error => {
            console.error('Error:', error);
            errorMessage.textContent = '{{ trans("messages.error_occurred") }}';
            errorMessage.classList.remove('d-none');
        })
        .finally(() => {
            saveBtn.disabled = false;
            saveBtn.innerHTML = '{{ trans("messages.create") }}';
        });
    });

    // Reset form when modal is closed
    document.getElementById('addCategoryModal').addEventListener('hidden.bs.modal', function() {
        addCategoryForm.reset();
        errorMessage.classList.add('d-none');
        document.getElementById('new_category_name').classList.remove('is-invalid');
    });
});
</script>
@endpush
@endsection
