@extends('layouts.master')

@section('title', trans('messages.products'))

@section('content')
@php
    $sort = request()->get('sort', 'created_at');
    $direction = request()->get('direction', 'desc');
@endphp
<div class="page-header">
    <h2>{{ trans('messages.products') }}</h2>
    <div>
        @can('products.create')
            <a href="{{ route('products.create') }}" class="btn btn-primary"><i class="bi bi-plus-circle"></i> {{ trans('messages.add_product') }}</a>
        @endcan
        @can('products.import')
            <a href="{{ route('products.import') }}" class="btn btn-success"><i class="bi bi-upload"></i> {{ trans('messages.import_products') }}</a>
        @endcan
        @can('products.reports')
            <a href="{{ route('products.reports') }}" class="btn btn-info"><i class="bi bi-graph-up"></i> {{ trans('messages.product_reports') }}</a>
        @endcan
        @can('products.view')
            <a href="{{ route('products.print_low_stock') }}" class="btn btn-warning" target="_blank"><i class="bi bi-printer"></i> {{ trans('messages.print_low_stock') }}</a>
        @endcan
    </div>
</div>

<div class="card">
    <div class="card-body">
        <form method="GET" action="{{ route('products.index') }}" class="mb-3">
            <div class="row g-3">
                <div class="col-md-4">
                    <input type="text" name="search" class="form-control" placeholder="{{ trans('messages.search') }}..." value="{{ request('search') }}">
                </div>
                <div class="col-md-3">
                    <select name="category_id" class="form-select">
                        <option value="">{{ trans('messages.all_categories') }}</option>
                        @foreach($categories as $category)
                            <option value="{{ $category->id }}" {{ request('category_id') == $category->id ? 'selected' : '' }}>{{ $category->name }}</option>
                        @endforeach
                    </select>
                </div>
                <div class="col-md-2">
                    <button type="submit" class="btn btn-secondary w-100">{{ trans('messages.filter') }}</button>
                </div>
                <div class="col-md-3 text-end">
                    @can('products.export')
                        <a href="{{ route('products.export') }}" class="btn btn-success"><i class="bi bi-download"></i> {{ trans('messages.export_csv') }}</a>
                    @endcan
                </div>
            </div>
        </form>

        @can('products.bulk_delete')
        <div class="mb-3">
            <button type="button" id="delete-selected-btn" class="btn btn-danger" disabled>
                <i class="bi bi-trash"></i> {{ trans('messages.delete_selected') }}
            </button>
        </div>
        @endcan

        <div class="table-responsive">
            <table class="table table-hover">
                    <thead>
                        <tr>
                            @can('products.bulk_delete')
                            <th style="width: 40px;">
                                <input type="checkbox" id="select-all" title="{{ trans('messages.select_all') }}">
                            </th>
                            @endcan
                            <th>
                            <a href="{{ request()->fullUrlWithQuery(['sort' => 'sku', 'direction' => ($sort === 'sku' && $direction === 'asc') ? 'desc' : 'asc']) }}" class="text-decoration-none text-dark">
                                {{ trans('messages.sku') }}
                                @if($sort === 'sku')
                                    <i class="bi bi-arrow-{{ $direction === 'asc' ? 'up' : 'down' }}"></i>
                                @else
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                @endif
                            </a>
                        </th>
                        <th>
                            <a href="{{ request()->fullUrlWithQuery(['sort' => 'name', 'direction' => ($sort === 'name' && $direction === 'asc') ? 'desc' : 'asc']) }}" class="text-decoration-none text-dark">
                                {{ trans('messages.name') }}
                                @if($sort === 'name')
                                    <i class="bi bi-arrow-{{ $direction === 'asc' ? 'up' : 'down' }}"></i>
                                @else
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                @endif
                            </a>
                        </th>
                        <th>{{ trans('messages.category') }}</th>
                        <th>
                            <a href="{{ request()->fullUrlWithQuery(['sort' => 'stock_quantity', 'direction' => ($sort === 'stock_quantity' && $direction === 'asc') ? 'desc' : 'asc']) }}" class="text-decoration-none text-dark">
                                {{ trans('messages.stock') }}
                                @if($sort === 'stock_quantity')
                                    <i class="bi bi-arrow-{{ $direction === 'asc' ? 'up' : 'down' }}"></i>
                                @else
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                @endif
                            </a>
                        </th>
                        <th>
                            <a href="{{ request()->fullUrlWithQuery(['sort' => 'purchase_price', 'direction' => ($sort === 'purchase_price' && $direction === 'asc') ? 'desc' : 'asc']) }}" class="text-decoration-none text-dark">
                                {{ trans('messages.purchase_price') }}
                                @if($sort === 'purchase_price')
                                    <i class="bi bi-arrow-{{ $direction === 'asc' ? 'up' : 'down' }}"></i>
                                @else
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                @endif
                            </a>
                        </th>
                        <th>
                            <a href="{{ request()->fullUrlWithQuery(['sort' => 'selling_price', 'direction' => ($sort === 'selling_price' && $direction === 'asc') ? 'desc' : 'asc']) }}" class="text-decoration-none text-dark">
                                {{ trans('messages.selling_price') }}
                                @if($sort === 'selling_price')
                                    <i class="bi bi-arrow-{{ $direction === 'asc' ? 'up' : 'down' }}"></i>
                                @else
                                    <i class="bi bi-arrow-down-up text-muted"></i>
                                @endif
                            </a>
                        </th>
                        <th>{{ trans('messages.actions') }}</th>
                    </tr>
                </thead>
                <tbody>
                    @forelse($products as $product)
                    <tr>
                        @can('products.bulk_delete')
                        <td>
                            <input type="checkbox" class="item-checkbox" value="{{ $product->id }}">
                        </td>
                        @endcan
                        <td>{{ $product->sku }}</td>
                        <td>
                            <a href="{{ route('products.show', $product) }}">{{ $product->name }}</a>
                        </td>
                        <td>{{ $product->category?->name ?? 'N/A' }}</td>
                        <td>
                            {{ $product->stock_quantity }}
                            @if($product->isLowStock())
                                <span class="badge bg-danger ms-2">{{ trans('messages.low_stock') }}</span>
                            @endif
                        </td>
                        <td>{{ format_currency($product->purchase_price) }}</td>
                        <td>{{ format_currency($product->selling_price) }}</td>
                        <td>
                            @can('products.update')
                                <a href="{{ route('products.edit', $product) }}" class="btn btn-sm btn-warning" title="{{ trans('messages.edit') }}"><i class="bi bi-pencil"></i></a>
                            @endcan
                            @can('products.delete')
                                <form action="{{ route('products.destroy', $product) }}" method="POST" class="d-inline delete-form">
                                    @csrf
                                    @method('DELETE')
                                    <button type="submit" class="btn btn-sm btn-danger" title="{{ trans('messages.delete') }}" onclick="event.preventDefault(); confirmAction('{{ trans('messages.confirm_delete_product') }}', '{{ trans('messages.confirm_delete') }}', () => this.closest('form').submit()); return false;"><i class="bi bi-trash"></i></button>
                                </form>
                            @endcan
                        </td>
                    </tr>
                    @empty
                    <tr>
                        <td colspan="{{ auth()->user()->can('products.bulk_delete') ? '8' : '7' }}" class="text-center">{{ trans('messages.no_products_found') }}</td>
                    </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
        
        <!-- Hidden form for bulk delete -->
        <form id="bulk-delete-form" method="POST" action="{{ route('products.bulk_delete') }}" style="display: none;">
            @csrf
        </form>

        {{ $products->links() }}
    </div>
</div>

@include('partials.bulk-delete-modal')
@endsection
