@extends('layouts.master')

@section('title', trans('messages.profile_settings'))

@section('content')
<div class="page-header">
    <h2>{{ trans('messages.profile_settings') }}</h2>
</div>

<div class="row">
    <div class="col-md-8">
        <div class="card mb-3">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.profile_information') }}</h5>
            </div>
            <div class="card-body">
                <form method="POST" action="{{ route('profile.update') }}" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')

                    <div class="mb-3">
                        <label for="name" class="form-label">{{ trans('messages.name') }} *</label>
                        <input type="text" class="form-control @error('name') is-invalid @enderror" id="name" name="name" value="{{ old('name', auth()->user()->name) }}" required>
                        @error('name')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="email" class="form-label">{{ trans('messages.email') }} *</label>
                        <input type="email" class="form-control @error('email') is-invalid @enderror" id="email" name="email" value="{{ old('email', auth()->user()->email) }}" required>
                        @error('email')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="phone" class="form-label">{{ trans('messages.phone') }}</label>
                        <input type="text" class="form-control @error('phone') is-invalid @enderror" id="phone" name="phone" value="{{ old('phone', auth()->user()->phone ?? '') }}">
                        @error('phone')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="avatar" class="form-label">{{ trans('messages.avatar') }}</label>
                        @if(auth()->user()->avatar)
                            <div class="mb-2">
                                <img src="{{ storage_url( auth()->user()->avatar) }}" alt="{{ trans('messages.avatar') }}" style="width: 100px; height: 100px; border-radius: 50%; object-fit: cover;">
                            </div>
                        @endif
                        <input type="file" class="form-control @error('avatar') is-invalid @enderror" id="avatar" name="avatar" accept="image/*">
                        @error('avatar')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <button type="submit" class="btn btn-primary">{{ trans('messages.update_profile') }}</button>
                </form>
            </div>
        </div>

        <div class="card">
            <div class="card-header">
                <h5 class="mb-0">{{ trans('messages.change_password') }}</h5>
            </div>
            <div class="card-body">
                <form method="POST" action="{{ route('profile.password.update') }}">
                    @csrf
                    @method('PUT')

                    <div class="mb-3">
                        <label for="old_password" class="form-label">{{ trans('messages.old_password') }} *</label>
                        <input type="password" class="form-control @error('old_password') is-invalid @enderror" id="old_password" name="old_password" required>
                        @error('old_password')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="mb-3">
                        <label for="new_password" class="form-label">{{ trans('messages.new_password') }} *</label>
                        <input type="password" class="form-control @error('new_password') is-invalid @enderror" id="new_password" name="new_password" required>
                        @error('new_password')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                        <small class="form-text text-muted">{{ trans('messages.password_min_8_chars') }}</small>
                    </div>

                    <div class="mb-3">
                        <label for="new_password_confirmation" class="form-label">{{ trans('messages.confirm_password') }} *</label>
                        <input type="password" class="form-control" id="new_password_confirmation" name="new_password_confirmation" required>
                    </div>

                    <button type="submit" class="btn btn-primary">{{ trans('messages.update_password') }}</button>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection

