@extends('layouts.master')

@section('title', trans('messages.add_promissory_note'))

@section('content')
@php
    $isRTL = app()->getLocale() === 'ar';
@endphp
<div class="page-header">
    <h2>{{ trans('messages.add_promissory_note') }}</h2>
    <a href="{{ route('promissory-notes.index') }}" class="btn btn-secondary">{{ trans('messages.back') }}</a>
</div>

<div class="card">
    <div class="card-body">
        <form method="POST" action="{{ route('promissory-notes.store') }}" id="promissory-note-form">
            @csrf
            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="type" class="form-label">{{ trans('messages.type') }} *</label>
                        <select class="form-select @error('type') is-invalid @enderror" id="type" name="type" required>
                            <option value="">{{ trans('messages.select') }}</option>
                            <option value="customer" {{ old('type', $type ?? '') === 'customer' ? 'selected' : '' }}>{{ trans('messages.customers') }}</option>
                            <option value="supplier" {{ old('type', $type ?? '') === 'supplier' ? 'selected' : '' }}>{{ trans('messages.suppliers') }}</option>
                        </select>
                        @error('type')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3" id="customer-field" style="display: none;">
                        <label for="customer_id" class="form-label">{{ trans('messages.customer') }} *</label>
                        <select class="form-select @error('customer_id') is-invalid @enderror" id="customer_id" name="customer_id">
                            <option value="">{{ trans('messages.select_customer') }}</option>
                            @foreach($customers as $customer)
                                <option value="{{ $customer->id }}" {{ old('customer_id', $customerId ?? '') == $customer->id ? 'selected' : '' }}>{{ $customer->name }}</option>
                            @endforeach
                        </select>
                        @error('customer_id')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="mb-3" id="supplier-field" style="display: none;">
                        <label for="supplier_id" class="form-label">{{ trans('messages.supplier') }} *</label>
                        <select class="form-select @error('supplier_id') is-invalid @enderror" id="supplier_id" name="supplier_id">
                            <option value="">{{ trans('messages.select_supplier') }}</option>
                            @foreach($suppliers as $supplier)
                                <option value="{{ $supplier->id }}" {{ old('supplier_id', $supplierId ?? '') == $supplier->id ? 'selected' : '' }}>{{ $supplier->name }}</option>
                            @endforeach
                        </select>
                        @error('supplier_id')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3" id="invoice-field" style="display: none;">
                        <label for="invoice_id" class="form-label">{{ trans('messages.invoice') }}</label>
                        <select class="form-select @error('invoice_id') is-invalid @enderror" id="invoice_id" name="invoice_id">
                            <option value="">{{ trans('messages.select_invoice') }}</option>
                            @foreach($invoices ?? [] as $invoice)
                                <option value="{{ $invoice->id }}" {{ old('invoice_id', $invoiceId ?? '') == $invoice->id ? 'selected' : '' }}>
                                    {{ $invoice->invoice_number }} - {{ format_currency($invoice->due_amount) }}
                                </option>
                            @endforeach
                        </select>
                        @error('invoice_id')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3" id="purchase-invoice-field" style="display: none;">
                        <label for="purchase_invoice_id" class="form-label">{{ trans('messages.purchase_invoice') }}</label>
                        <select class="form-select @error('purchase_invoice_id') is-invalid @enderror" id="purchase_invoice_id" name="purchase_invoice_id">
                            <option value="">{{ trans('messages.select_purchase_invoice') }}</option>
                            @foreach($purchaseInvoices ?? [] as $purchaseInvoice)
                                <option value="{{ $purchaseInvoice->id }}" {{ old('purchase_invoice_id', $purchaseInvoiceId ?? '') == $purchaseInvoice->id ? 'selected' : '' }}>
                                    {{ $purchaseInvoice->invoice_number }} - {{ format_currency($purchaseInvoice->amount_remaining) }}
                                </option>
                            @endforeach
                        </select>
                        @error('purchase_invoice_id')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="note_number" class="form-label">{{ trans('messages.note_number') }} *</label>
                        <input type="text" class="form-control @error('note_number') is-invalid @enderror" id="note_number" name="note_number" value="{{ old('note_number') }}" required>
                        @error('note_number')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="amount" class="form-label">{{ trans('messages.amount') }} *</label>
                        <input type="number" step="0.01" class="form-control @error('amount') is-invalid @enderror" id="amount" name="amount" value="{{ old('amount', $amount ?? '') }}" required>
                        @error('amount')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="issue_date" class="form-label">{{ trans('messages.issue_date') }} *</label>
                        <input type="date" class="form-control @error('issue_date') is-invalid @enderror" id="issue_date" name="issue_date" value="{{ old('issue_date', date('Y-m-d')) }}" required>
                        @error('issue_date')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="due_date" class="form-label">{{ trans('messages.due_date') }} *</label>
                        <input type="date" class="form-control @error('due_date') is-invalid @enderror" id="due_date" name="due_date" value="{{ old('due_date') }}" required>
                        @error('due_date')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="mb-3">
                <label for="notes" class="form-label">{{ trans('messages.notes') }}</label>
                <textarea class="form-control @error('notes') is-invalid @enderror" id="notes" name="notes" rows="3">{{ old('notes') }}</textarea>
                @error('notes')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <button type="submit" class="btn btn-primary">{{ trans('messages.create') }}</button>
        </form>
    </div>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const typeSelect = document.getElementById('type');
    const customerField = document.getElementById('customer-field');
    const supplierField = document.getElementById('supplier-field');
    const invoiceField = document.getElementById('invoice-field');
    const purchaseInvoiceField = document.getElementById('purchase-invoice-field');
    const customerSelect = document.getElementById('customer_id');
    const supplierSelect = document.getElementById('supplier_id');

    function toggleFields() {
        const type = typeSelect.value;
        if (type === 'customer') {
            customerField.style.display = 'block';
            supplierField.style.display = 'none';
            invoiceField.style.display = 'block';
            purchaseInvoiceField.style.display = 'none';
            customerSelect.required = true;
            supplierSelect.required = false;
        } else if (type === 'supplier') {
            customerField.style.display = 'none';
            supplierField.style.display = 'block';
            invoiceField.style.display = 'none';
            purchaseInvoiceField.style.display = 'block';
            customerSelect.required = false;
            supplierSelect.required = true;
        } else {
            customerField.style.display = 'none';
            supplierField.style.display = 'none';
            invoiceField.style.display = 'none';
            purchaseInvoiceField.style.display = 'none';
            customerSelect.required = false;
            supplierSelect.required = false;
        }
    }

    typeSelect.addEventListener('change', function() {
        toggleFields();
        // Load invoices when customer/supplier changes
        if (this.value === 'customer') {
            loadInvoices();
        } else if (this.value === 'supplier') {
            loadPurchaseInvoices();
        }
    });

    customerSelect.addEventListener('change', function() {
        loadInvoices();
    });

    supplierSelect.addEventListener('change', function() {
        loadPurchaseInvoices();
    });

    function loadInvoices() {
        const customerId = customerSelect.value;
        
        if (!customerId || !invoiceField || invoiceField.style.display === 'none') {
            return;
        }
        
        const invoiceSelect = invoiceField.querySelector('select');
        if (!invoiceSelect) {
            return;
        }

        // Show loading state
        invoiceSelect.innerHTML = '<option value="">{{ trans("messages.loading") }}...</option>';
        invoiceSelect.disabled = true;

        // AJAX call to load invoices
        const selectedInvoiceId = {{ old('invoice_id', $invoiceId ?? 'null') }};
        const url = `{{ route('promissory-notes.get-invoices', '') }}/${customerId}` + (selectedInvoiceId ? `?invoice_id=${selectedInvoiceId}` : '');
        fetch(url, {
            method: 'GET',
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'Accept': 'application/json',
            }
        })
        .then(response => response.json())
        .then(data => {
            invoiceSelect.innerHTML = '<option value="">{{ trans("messages.select_invoice") }}</option>';
            const selectedInvoiceId = {{ old('invoice_id', $invoiceId ?? 'null') }};
            data.forEach(function(invoice) {
                const option = document.createElement('option');
                option.value = invoice.id;
                option.textContent = invoice.invoice_number + ' - ' + invoice.formatted_due_amount;
                if (selectedInvoiceId && invoice.id == selectedInvoiceId) {
                    option.selected = true;
                }
                invoiceSelect.appendChild(option);
            });
            invoiceSelect.disabled = false;
        })
        .catch(error => {
            console.error('Error loading invoices:', error);
            invoiceSelect.innerHTML = '<option value="">{{ trans("messages.error_loading_invoices") }}</option>';
            invoiceSelect.disabled = false;
        });
    }

    function loadPurchaseInvoices() {
        const supplierId = supplierSelect.value;
        
        if (!supplierId || !purchaseInvoiceField || purchaseInvoiceField.style.display === 'none') {
            return;
        }
        
        const purchaseInvoiceSelect = purchaseInvoiceField.querySelector('select');
        if (!purchaseInvoiceSelect) {
            return;
        }

        // Show loading state
        purchaseInvoiceSelect.innerHTML = '<option value="">{{ trans("messages.loading") }}...</option>';
        purchaseInvoiceSelect.disabled = true;

        // AJAX call to load purchase invoices
        const selectedPurchaseInvoiceId = {{ old('purchase_invoice_id', $purchaseInvoiceId ?? 'null') }};
        const url = `{{ route('promissory-notes.get-purchase-invoices', '') }}/${supplierId}` + (selectedPurchaseInvoiceId ? `?purchase_invoice_id=${selectedPurchaseInvoiceId}` : '');
        fetch(url, {
            method: 'GET',
            headers: {
                'X-Requested-With': 'XMLHttpRequest',
                'Accept': 'application/json',
            }
        })
        .then(response => response.json())
        .then(data => {
            purchaseInvoiceSelect.innerHTML = '<option value="">{{ trans("messages.select_purchase_invoice") }}</option>';
            const selectedPurchaseInvoiceId = {{ old('purchase_invoice_id', $purchaseInvoiceId ?? 'null') }};
            data.forEach(function(purchaseInvoice) {
                const option = document.createElement('option');
                option.value = purchaseInvoice.id;
                option.textContent = purchaseInvoice.invoice_number + ' - ' + purchaseInvoice.formatted_amount_remaining;
                if (selectedPurchaseInvoiceId && purchaseInvoice.id == selectedPurchaseInvoiceId) {
                    option.selected = true;
                }
                purchaseInvoiceSelect.appendChild(option);
            });
            purchaseInvoiceSelect.disabled = false;
        })
        .catch(error => {
            console.error('Error loading purchase invoices:', error);
            purchaseInvoiceSelect.innerHTML = '<option value="">{{ trans("messages.error_loading_invoices") }}</option>';
            purchaseInvoiceSelect.disabled = false;
        });
    }

    // Date validation: due_date must be after or equal to issue_date
    const issueDateInput = document.getElementById('issue_date');
    const dueDateInput = document.getElementById('due_date');

    function updateDueDateMin() {
        const issueDate = issueDateInput.value;
        if (issueDate) {
            dueDateInput.setAttribute('min', issueDate);
            // If due_date is before issue_date, clear it
            if (dueDateInput.value && dueDateInput.value < issueDate) {
                dueDateInput.value = '';
            }
        }
    }

    issueDateInput.addEventListener('change', updateDueDateMin);
    
    // Initialize on page load
    toggleFields();
    updateDueDateMin();
    
    // Auto-load invoices/purchase invoices if customer/supplier is already selected
    // Use setTimeout to ensure fields are visible after toggleFields()
    setTimeout(function() {
        if (typeSelect.value === 'customer' && customerSelect.value && invoiceField && invoiceField.style.display !== 'none') {
            console.log('Auto-loading invoices for customer:', customerSelect.value);
            loadInvoices();
        } else if (typeSelect.value === 'supplier' && supplierSelect.value && purchaseInvoiceField && purchaseInvoiceField.style.display !== 'none') {
            console.log('Auto-loading purchase invoices for supplier:', supplierSelect.value);
            loadPurchaseInvoices();
        }
    }, 200);
});
</script>
@endpush
@endsection

