@extends('layouts.master')

@section('title', trans('messages.edit_promissory_note'))

@section('content')
@php
    $isRTL = app()->getLocale() === 'ar';
@endphp
<div class="page-header">
    <h2>{{ trans('messages.edit_promissory_note') }}</h2>
    <a href="{{ route('promissory-notes.show', $promissoryNote) }}" class="btn btn-secondary">{{ trans('messages.back') }}</a>
</div>

<div class="card">
    <div class="card-body">
        <form method="POST" action="{{ route('promissory-notes.update', $promissoryNote) }}" id="promissory-note-form">
            @csrf
            @method('PUT')
            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="type" class="form-label">{{ trans('messages.type') }} *</label>
                        <select class="form-select @error('type') is-invalid @enderror" id="type" name="type" required>
                            <option value="">{{ trans('messages.select') }}</option>
                            <option value="customer" {{ old('type', $promissoryNote->type) === 'customer' ? 'selected' : '' }}>{{ trans('messages.customers') }}</option>
                            <option value="supplier" {{ old('type', $promissoryNote->type) === 'supplier' ? 'selected' : '' }}>{{ trans('messages.suppliers') }}</option>
                        </select>
                        @error('type')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3" id="customer-field" style="display: {{ $promissoryNote->type === 'customer' ? 'block' : 'none' }};">
                        <label for="customer_id" class="form-label">{{ trans('messages.customer') }} *</label>
                        <select class="form-select @error('customer_id') is-invalid @enderror" id="customer_id" name="customer_id">
                            <option value="">{{ trans('messages.select_customer') }}</option>
                            @foreach($customers as $customer)
                                <option value="{{ $customer->id }}" {{ old('customer_id', $promissoryNote->customer_id) == $customer->id ? 'selected' : '' }}>{{ $customer->name }}</option>
                            @endforeach
                        </select>
                        @error('customer_id')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="mb-3" id="supplier-field" style="display: {{ $promissoryNote->type === 'supplier' ? 'block' : 'none' }};">
                        <label for="supplier_id" class="form-label">{{ trans('messages.supplier') }} *</label>
                        <select class="form-select @error('supplier_id') is-invalid @enderror" id="supplier_id" name="supplier_id">
                            <option value="">{{ trans('messages.select_supplier') }}</option>
                            @foreach($suppliers as $supplier)
                                <option value="{{ $supplier->id }}" {{ old('supplier_id', $promissoryNote->supplier_id) == $supplier->id ? 'selected' : '' }}>{{ $supplier->name }}</option>
                            @endforeach
                        </select>
                        @error('supplier_id')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3" id="invoice-field" style="display: {{ $promissoryNote->type === 'customer' ? 'block' : 'none' }};">
                        <label for="invoice_id" class="form-label">{{ trans('messages.invoice') }}</label>
                        <select class="form-select @error('invoice_id') is-invalid @enderror" id="invoice_id" name="invoice_id">
                            <option value="">{{ trans('messages.select_invoice') }}</option>
                            @foreach($invoices ?? [] as $invoice)
                                <option value="{{ $invoice->id }}" {{ old('invoice_id', $promissoryNote->invoice_id) == $invoice->id ? 'selected' : '' }}>
                                    {{ $invoice->invoice_number }} - {{ format_currency($invoice->due_amount) }}
                                </option>
                            @endforeach
                        </select>
                        @error('invoice_id')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3" id="purchase-invoice-field" style="display: {{ $promissoryNote->type === 'supplier' ? 'block' : 'none' }};">
                        <label for="purchase_invoice_id" class="form-label">{{ trans('messages.purchase_invoice') }}</label>
                        <select class="form-select @error('purchase_invoice_id') is-invalid @enderror" id="purchase_invoice_id" name="purchase_invoice_id">
                            <option value="">{{ trans('messages.select_purchase_invoice') }}</option>
                            @foreach($purchaseInvoices ?? [] as $purchaseInvoice)
                                <option value="{{ $purchaseInvoice->id }}" {{ old('purchase_invoice_id', $promissoryNote->purchase_invoice_id) == $purchaseInvoice->id ? 'selected' : '' }}>
                                    {{ $purchaseInvoice->invoice_number }} - {{ format_currency($purchaseInvoice->amount_remaining) }}
                                </option>
                            @endforeach
                        </select>
                        @error('purchase_invoice_id')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="note_number" class="form-label">{{ trans('messages.note_number') }} *</label>
                        <input type="text" class="form-control @error('note_number') is-invalid @enderror" id="note_number" name="note_number" value="{{ old('note_number', $promissoryNote->note_number) }}" required>
                        @error('note_number')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="amount" class="form-label">{{ trans('messages.amount') }} *</label>
                        <input type="number" step="0.01" class="form-control @error('amount') is-invalid @enderror" id="amount" name="amount" value="{{ old('amount', $promissoryNote->amount) }}" required>
                        @error('amount')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="issue_date" class="form-label">{{ trans('messages.issue_date') }} *</label>
                        <input type="date" class="form-control @error('issue_date') is-invalid @enderror" id="issue_date" name="issue_date" value="{{ old('issue_date', $promissoryNote->issue_date->format('Y-m-d')) }}" required>
                        @error('issue_date')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
                <div class="col-md-6">
                    <div class="mb-3">
                        <label for="due_date" class="form-label">{{ trans('messages.due_date') }} *</label>
                        <input type="date" class="form-control @error('due_date') is-invalid @enderror" id="due_date" name="due_date" value="{{ old('due_date', $promissoryNote->due_date->format('Y-m-d')) }}" required>
                        @error('due_date')
                            <div class="invalid-feedback">{{ $message }}</div>
                        @enderror
                    </div>
                </div>
            </div>

            <div class="mb-3">
                <label for="notes" class="form-label">{{ trans('messages.notes') }}</label>
                <textarea class="form-control @error('notes') is-invalid @enderror" id="notes" name="notes" rows="3">{{ old('notes', $promissoryNote->notes) }}</textarea>
                @error('notes')
                    <div class="invalid-feedback">{{ $message }}</div>
                @enderror
            </div>

            <button type="submit" class="btn btn-primary">{{ trans('messages.update') }}</button>
        </form>
    </div>
</div>

@push('scripts')
<script>
document.addEventListener('DOMContentLoaded', function() {
    const typeSelect = document.getElementById('type');
    const customerField = document.getElementById('customer-field');
    const supplierField = document.getElementById('supplier-field');
    const invoiceField = document.getElementById('invoice-field');
    const purchaseInvoiceField = document.getElementById('purchase-invoice-field');
    const customerSelect = document.getElementById('customer_id');
    const supplierSelect = document.getElementById('supplier_id');

    function toggleFields() {
        const type = typeSelect.value;
        if (type === 'customer') {
            customerField.style.display = 'block';
            supplierField.style.display = 'none';
            invoiceField.style.display = 'block';
            purchaseInvoiceField.style.display = 'none';
            customerSelect.required = true;
            supplierSelect.required = false;
        } else if (type === 'supplier') {
            customerField.style.display = 'none';
            supplierField.style.display = 'block';
            invoiceField.style.display = 'none';
            purchaseInvoiceField.style.display = 'block';
            customerSelect.required = false;
            supplierSelect.required = true;
        } else {
            customerField.style.display = 'none';
            supplierField.style.display = 'none';
            invoiceField.style.display = 'none';
            purchaseInvoiceField.style.display = 'none';
            customerSelect.required = false;
            supplierSelect.required = false;
        }
    }

    typeSelect.addEventListener('change', toggleFields);
    toggleFields();

    // Date validation: due_date must be after or equal to issue_date
    const issueDateInput = document.getElementById('issue_date');
    const dueDateInput = document.getElementById('due_date');

    function updateDueDateMin() {
        const issueDate = issueDateInput.value;
        if (issueDate) {
            dueDateInput.setAttribute('min', issueDate);
            // If due_date is before issue_date, clear it
            if (dueDateInput.value && dueDateInput.value < issueDate) {
                dueDateInput.value = '';
            }
        }
    }

    issueDateInput.addEventListener('change', updateDueDateMin);
    
    // Initialize on page load
    updateDueDateMin();
});
</script>
@endpush
@endsection

